/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.graph;

import java.io.Serializable;
import org.arp.javautil.graph.WeightFactory;

public final class Weight
implements Comparable<Weight>,
Serializable {
    private static final long serialVersionUID = -20812788110969523L;
    private boolean isInfinity = false;
    private boolean posOrNeg = true;
    private long val;
    private volatile transient int hashCode;

    Weight() {
    }

    Weight(long val) {
        this.val = val;
    }

    Weight(Number val) {
        if (val != null) {
            this.val = val.longValue();
        }
    }

    Weight(boolean posOrNeg) {
        this.isInfinity = true;
        this.posOrNeg = posOrNeg;
    }

    Weight(Weight w) {
        if (w != null) {
            this.isInfinity = w.isInfinity;
            this.posOrNeg = w.posOrNeg;
            this.val = w.val;
        }
    }

    void set(Weight w) {
        if (w != null) {
            this.isInfinity = w.isInfinity;
            this.posOrNeg = w.posOrNeg;
            this.val = w.val;
        } else {
            this.isInfinity = false;
            this.posOrNeg = true;
            this.val = 0L;
        }
        this.hashCode = 0;
    }

    public long value() {
        if (this.isInfinity && !this.posOrNeg) {
            return Long.MIN_VALUE;
        }
        if (this.isInfinity && this.posOrNeg) {
            return Long.MAX_VALUE;
        }
        return this.val;
    }

    public boolean greaterThan(long val) {
        if (this.isInfinity && this.posOrNeg) {
            return true;
        }
        if (this.isInfinity && !this.posOrNeg) {
            return false;
        }
        return this.val > val;
    }

    public int compareToLong(long val) {
        if (this.greaterThan(val)) {
            return 1;
        }
        if (this.lessThan(val)) {
            return -1;
        }
        return 0;
    }

    public boolean lessThan(long val) {
        if (this.isInfinity && !this.posOrNeg) {
            return true;
        }
        if (this.isInfinity && this.posOrNeg) {
            return false;
        }
        return this.val < val;
    }

    public boolean isEqual(long val) {
        if (this.isInfinity) {
            return false;
        }
        return this.val == val;
    }

    public Weight add(Weight w) {
        if (w == null) {
            return new Weight(this);
        }
        boolean wIsInfinity = w.isInfinity;
        boolean wPosOrNeg = w.posOrNeg;
        if (this.isInfinity && this.posOrNeg && wIsInfinity && !wPosOrNeg || this.isInfinity && !this.posOrNeg && wIsInfinity && wPosOrNeg) {
            throw new IllegalArgumentException("+inf - inf!");
        }
        if (this.isInfinity && this.posOrNeg || w.isInfinity && wPosOrNeg) {
            return WeightFactory.POS_INFINITY;
        }
        if (this.isInfinity && !this.posOrNeg || wIsInfinity && !wPosOrNeg) {
            return WeightFactory.NEG_INFINITY;
        }
        return new Weight(this.val + w.val);
    }

    void addToSelf(Weight w) {
        if (w != null) {
            boolean wIsInfinity = w.isInfinity;
            boolean wPosOrNeg = w.posOrNeg;
            if (this.isInfinity && this.posOrNeg && wIsInfinity && !wPosOrNeg || this.isInfinity && !this.posOrNeg && wIsInfinity && wPosOrNeg) {
                throw new IllegalArgumentException("+inf - inf!");
            }
            if (this.isInfinity && this.posOrNeg || wIsInfinity && wPosOrNeg) {
                this.set(WeightFactory.POS_INFINITY);
            } else if (this.isInfinity && !this.posOrNeg || wIsInfinity && !wPosOrNeg) {
                this.set(WeightFactory.NEG_INFINITY);
            } else {
                this.val += w.val;
                this.hashCode = 0;
            }
        }
    }

    public Weight subtract(Weight w) {
        if (w == null) {
            return new Weight(this);
        }
        boolean wIsInfinity = w.isInfinity;
        boolean wPosOrNeg = w.posOrNeg;
        if (this.isInfinity && this.posOrNeg && wIsInfinity && wPosOrNeg || this.isInfinity && !this.posOrNeg && wIsInfinity && !wPosOrNeg) {
            throw new IllegalArgumentException("+inf - inf!");
        }
        if (this.isInfinity && this.posOrNeg || wIsInfinity && !wPosOrNeg) {
            return WeightFactory.POS_INFINITY;
        }
        if (this.isInfinity && !this.posOrNeg || wIsInfinity && wPosOrNeg) {
            return WeightFactory.NEG_INFINITY;
        }
        return new Weight(this.val - w.val);
    }

    public static Weight max(Weight w1, Weight w2) {
        if (w1 == null) {
            throw new IllegalArgumentException("Argument w1 cannot be null");
        }
        if (w2 == null) {
            throw new IllegalArgumentException("Argument w2 cannot be null");
        }
        if (w1.isInfinity && w1.posOrNeg || w2.isInfinity && !w2.posOrNeg) {
            return w1;
        }
        if (w2.isInfinity && w2.posOrNeg || w1.isInfinity && !w1.posOrNeg) {
            return w2;
        }
        if (w1.val >= w2.val) {
            return w1;
        }
        return w2;
    }

    public static Weight min(Weight w1, Weight w2) {
        if (w1 == null) {
            throw new IllegalArgumentException("Argument w1 cannot be null");
        }
        if (w2 == null) {
            throw new IllegalArgumentException("Argument w2 cannot be null");
        }
        if (w1.isInfinity && !w1.posOrNeg || w2.isInfinity && w2.posOrNeg) {
            return w1;
        }
        if (w2.isInfinity && !w2.posOrNeg || w1.isInfinity && w1.posOrNeg) {
            return w2;
        }
        if (w1.val <= w2.val) {
            return w1;
        }
        return w2;
    }

    public boolean isPositiveInfinity() {
        return this.isInfinity && this.posOrNeg;
    }

    public boolean isNegativeInfinity() {
        return this.isInfinity && !this.posOrNeg;
    }

    public boolean isInfinity() {
        return this.isInfinity;
    }

    public Weight invertSign() {
        if (this.isInfinity) {
            if (this.posOrNeg) {
                return WeightFactory.NEG_INFINITY;
            }
            return WeightFactory.POS_INFINITY;
        }
        return new Weight(-this.val);
    }

    public String toString() {
        if (this.isInfinity) {
            if (this.posOrNeg) {
                return "+inf";
            }
            if (!this.posOrNeg) {
                return "-inf";
            }
        }
        return String.valueOf(this.val);
    }

    @Override
    public int compareTo(Weight anotherWeight) {
        boolean wIsInfinity = anotherWeight.isInfinity;
        boolean wPosOrNeg = anotherWeight.posOrNeg;
        if (this.isInfinity && wIsInfinity && (this.posOrNeg && wPosOrNeg || !this.posOrNeg && !wPosOrNeg)) {
            return 0;
        }
        if (this.isInfinity && this.posOrNeg || wIsInfinity && !wPosOrNeg) {
            return 1;
        }
        if (this.isInfinity && !this.posOrNeg || wIsInfinity && wPosOrNeg) {
            return -1;
        }
        if (this.val < anotherWeight.val) {
            return -1;
        }
        if (this.val > anotherWeight.val) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Weight w = (Weight)o;
        return this.isInfinity == w.isInfinity && this.posOrNeg == w.posOrNeg && this.val == w.val;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + (this.isInfinity ? 0 : 1);
            result = 37 * result + (this.posOrNeg ? 0 : 1);
            this.hashCode = result = 37 * result + (int)(this.val ^ this.val >>> 32);
        }
        return this.hashCode;
    }

    boolean isWithinRange(Weight min, Weight max) {
        return this.compareTo(min) >= 0 && this.compareTo(max) <= 0;
    }
}

