/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;

public abstract class WithLineNumberReader {
    private InputStreamReader inputStreamReader;

    public WithLineNumberReader(InputStream inputStream) {
        this(new InputStreamReader(inputStream));
    }

    public WithLineNumberReader(String file) throws FileNotFoundException {
        this(new File(file));
    }

    public WithLineNumberReader(File file) throws FileNotFoundException {
        this(new FileReader(file));
    }

    public WithLineNumberReader(InputStreamReader inputStreamReader) {
        this.inputStreamReader = inputStreamReader;
    }

    public abstract void readLine(int var1, String var2);

    public void execute() throws IOException {
        LineNumberReader r = new LineNumberReader(this.inputStreamReader);
        try {
            String line;
            while ((line = r.readLine()) != null) {
                this.readLine(r.getLineNumber(), line);
            }
            r.close();
            r = null;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
            this.inputStreamReader = null;
        }
    }
}

