/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.string;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final char QUOTE = '\"';
    private static final char[] SEARCH_CHARS = new char[]{'\"', '\r', '\n'};

    private StringUtil() {
    }

    public static boolean getEmptyOrNull(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean equals(String str1, String str2) {
        return str1 != null ? str1.equals(str2) : str2 == null;
    }

    public static List<String> escapeDelimitedColumns(List<String> columnValues, char delimiter) {
        return StringUtil.escapeDelimitedColumns(columnValues, null, delimiter);
    }

    public static List<String> escapeDelimitedColumns(List<String> columnValues, Map<String, String> replace, char delimiter) {
        ArrayList<String> result = new ArrayList<String>(columnValues.size());
        for (String value : columnValues) {
            value = StringUtil.doReplace(value, replace);
            result.add(StringUtil.escapeDelimitedColumn(value, delimiter));
        }
        return result;
    }

    public static void escapeDelimitedColumnsInPlace(List<String> columnValues, char delimiter) {
        StringUtil.escapeDelimitedColumnsInPlace(columnValues, null, delimiter);
    }

    public static void escapeDelimitedColumnsInPlace(List<String> columnValues, Map<String, String> replace, char delimiter) {
        int n = columnValues.size();
        for (int i = 0; i < n; ++i) {
            String value = columnValues.get(i);
            value = StringUtil.doReplace(value, replace);
            columnValues.set(i, StringUtil.escapeDelimitedColumn(value, delimiter));
        }
    }

    public static String[] escapeDelimitedColumns(String[] columnValues, char delimiter) {
        return StringUtil.escapeDelimitedColumns(columnValues, null, delimiter);
    }

    public static String[] escapeDelimitedColumns(String[] columnValues, Map<String, String> replace, char delimiter) {
        String[] result = new String[columnValues.length];
        for (int i = 0; i < columnValues.length; ++i) {
            String columnValue = columnValues[i];
            columnValue = StringUtil.doReplace(columnValue, replace);
            result[i] = StringUtil.escapeDelimitedColumn(columnValue, delimiter);
        }
        return result;
    }

    public static void escapeDelimitedColumnsInPlace(String[] columnValues, char delimiter) {
        StringUtil.escapeDelimitedColumnsInPlace(columnValues, null, delimiter);
    }

    public static void escapeDelimitedColumnsInPlace(String[] columnValues, Map<String, String> replace, char delimiter) {
        for (int i = 0; i < columnValues.length; ++i) {
            String columnValue = columnValues[i];
            if (replace != null && replace.containsKey(columnValue)) {
                columnValue = replace.get(columnValue);
            }
            columnValues[i] = StringUtil.escapeDelimitedColumn(columnValue, delimiter);
        }
    }

    public static void escapeAndWriteDelimitedColumns(String[] columnValues, char delimiter, Writer writer) throws IOException {
        StringUtil.escapeAndWriteDelimitedColumns(columnValues, null, delimiter, writer);
    }

    public static void escapeAndWriteDelimitedColumns(String[] columnValues, Map<String, String> replace, char delimiter, Writer writer) throws IOException {
        for (int i = 0; i < columnValues.length; ++i) {
            String columnValue = columnValues[i];
            columnValue = StringUtil.doReplace(columnValue, replace);
            StringUtil.escapeAndWriteDelimitedColumn(columnValue, delimiter, writer);
            if (i >= columnValues.length - 1) continue;
            writer.write(delimiter);
        }
    }

    public static void escapeAndWriteDelimitedColumns(List<String> columnValues, char delimiter, Writer writer) throws IOException {
        StringUtil.escapeAndWriteDelimitedColumns(columnValues, null, delimiter, writer);
    }

    public static void escapeAndWriteDelimitedColumns(List<String> columnValues, Map<String, String> replace, char delimiter, Writer writer) throws IOException {
        int n = columnValues.size();
        for (int i = 0; i < n; ++i) {
            String columnValue = columnValues.get(i);
            columnValue = StringUtil.doReplace(columnValue, replace);
            StringUtil.escapeAndWriteDelimitedColumn(columnValue, delimiter, writer);
            if (i >= n - 1) continue;
            writer.write(delimiter);
        }
    }

    public static void escapeAndWriteDelimitedColumn(String str, char delimiter, Map<String, String> replace, Writer writer) throws IOException {
        if ((str = StringUtil.doReplace(str, replace)) == null || StringUtils.containsNone((CharSequence)str, (char[])SEARCH_CHARS) && str.indexOf(delimiter) < 0) {
            writer.write(str);
        } else {
            writer.write(34);
            int n = str.length();
            for (int j = 0; j < n; ++j) {
                char c = str.charAt(j);
                if (c == '\"') {
                    writer.write(34);
                }
                writer.write(c);
            }
            writer.write(34);
        }
    }

    public static void escapeAndWriteDelimitedColumn(String str, char delimiter, Writer writer) throws IOException {
        if (str == null || StringUtils.containsNone((CharSequence)str, (char[])SEARCH_CHARS) && str.indexOf(delimiter) < 0) {
            writer.write(str);
        } else {
            writer.write(34);
            int n = str.length();
            for (int j = 0; j < n; ++j) {
                char c = str.charAt(j);
                if (c == '\"') {
                    writer.write(34);
                }
                writer.write(c);
            }
            writer.write(34);
        }
    }

    public static String escapeDelimitedColumn(String str, char delimiter) {
        if (str == null || StringUtils.containsNone((CharSequence)str, (char[])SEARCH_CHARS) && str.indexOf(delimiter) < 0) {
            return str;
        }
        StringBuilder writer = new StringBuilder();
        writer.append('\"');
        int n = str.length();
        for (int j = 0; j < n; ++j) {
            char c = str.charAt(j);
            if (c == '\"') {
                writer.append('\"');
            }
            writer.append(c);
        }
        writer.append('\"');
        return writer.toString();
    }

    private static String doReplace(String columnValue, Map<String, String> replace) {
        if (replace != null && replace.containsKey(columnValue)) {
            return replace.get(columnValue);
        }
        return columnValue;
    }
}

