/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import sun.misc.Unsafe;

public final class UnsafeUtil {
    private static final Unsafe unsafe;
    private static final MethodHandle getAndAddInt;
    private static final MethodHandle getAndSetObject;
    private static final String allowUnalignedMemoryAccessProperty = "org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil.allowUnalignedMemoryAccess";
    private static final Class<?> directByteBufferClass;
    private static final Constructor<?> directByteBufferCtor;
    private static final long directByteBufferCapacityOffset;
    private static final long directByteBufferLimitOffset;
    private static final long directByteBufferMarkOffset;
    private static final long directByteBufferAddressOffset;
    public static final boolean allowUnalignedMemoryAccess;
    public static final boolean storeByteOrderIsNative;

    private static Unsafe getUnsafe() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    try {
                        return Unsafe.getUnsafe();
                    }
                    catch (Exception e) {
                        Field[] fields;
                        Class<Unsafe> type = Unsafe.class;
                        for (Field field : fields = type.getDeclaredFields()) {
                            if (!Modifier.isStatic(field.getModifiers()) || !type.isAssignableFrom(field.getType())) continue;
                            field.setAccessible(true);
                            return (Unsafe)type.cast(field.get(null));
                        }
                        LinkageError error = new LinkageError("No static field of type sun.misc.Unsafe");
                        error.addSuppressed(e);
                        throw error;
                    }
                }
            });
        }
        catch (Exception e) {
            throw new LinkageError("Cannot access sun.misc.Unsafe", e);
        }
    }

    public static void assertHasUnsafe() {
        if (unsafe == null) {
            throw new LinkageError("Unsafe not available");
        }
    }

    private static MethodHandle getGetAndAddIntMethodHandle(MethodHandles.Lookup lookup) {
        MethodType type = MethodType.methodType(Integer.TYPE, Object.class, Long.TYPE, Integer.TYPE);
        try {
            return lookup.findVirtual(Unsafe.class, "getAndAddInt", type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static MethodHandle getGetAndSetObjectMethodHandle(MethodHandles.Lookup lookup) {
        MethodType type = MethodType.methodType(Object.class, Object.class, Long.TYPE, Object.class);
        try {
            return lookup.findVirtual(Unsafe.class, "getAndSetObject", type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static long getFieldOffset(Class<?> type, String field) {
        try {
            return unsafe.objectFieldOffset(type.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            String message = "Could not get offset of '" + field + "' field on type " + type;
            throw new LinkageError(message, e);
        }
    }

    public static int getAndAddInt(Object obj, long offset, int delta) {
        if (getAndAddInt != null) {
            return UnsafeUtil.getAndAddInt_java8(obj, offset, delta);
        }
        return UnsafeUtil.getAndAddInt_java7(obj, offset, delta);
    }

    private static int getAndAddInt_java8(Object obj, long offset, int delta) {
        try {
            return getAndAddInt.invokeExact(unsafe, obj, offset, delta);
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unexpected 'getAndAddInt' intrinsic failure", throwable);
        }
    }

    private static int getAndAddInt_java7(Object obj, long offset, int delta) {
        int x;
        while (!unsafe.compareAndSwapInt(obj, offset, x = unsafe.getIntVolatile(obj, offset), x + delta)) {
        }
        return x;
    }

    public static boolean compareAndSwapLong(Object obj, long offset, long expected, long update) {
        return unsafe.compareAndSwapLong(obj, offset, expected, update);
    }

    public static boolean compareAndSwapObject(Object obj, long offset, Object expected, Object update) {
        return unsafe.compareAndSwapObject(obj, offset, expected, update);
    }

    public static Object getAndSetObject(Object obj, long offset, Object newValue) {
        if (getAndSetObject != null) {
            return UnsafeUtil.getAndSetObject_java8(obj, offset, newValue);
        }
        return UnsafeUtil.getAndSetObject_java7(obj, offset, newValue);
    }

    private static Object getAndSetObject_java8(Object obj, long offset, Object newValue) {
        try {
            return getAndSetObject.invokeExact(unsafe, obj, offset, newValue);
        }
        catch (Throwable throwable) {
            throw new LinkageError("Unexpected 'getAndSetObject' intrinsic failure", throwable);
        }
    }

    private static Object getAndSetObject_java7(Object obj, long offset, Object newValue) {
        Object current;
        while (!unsafe.compareAndSwapObject(obj, offset, current = unsafe.getObjectVolatile(obj, offset), newValue)) {
        }
        return current;
    }

    public static long malloc(long sizeInBytes) {
        long pointer = unsafe.allocateMemory(sizeInBytes);
        unsafe.setMemory(pointer, sizeInBytes, (byte)0);
        return pointer;
    }

    public static void free(long pointer) {
        unsafe.freeMemory(pointer);
    }

    public static byte getByte(long address) {
        return unsafe.getByte(address);
    }

    public static void putByte(long address, byte value) {
        unsafe.putByte(address, value);
    }

    public static byte getByteVolatile(Object obj, long offset) {
        return unsafe.getByteVolatile(obj, offset);
    }

    public static void putByteVolatile(Object obj, long offset, byte value) {
        unsafe.putByteVolatile(obj, offset, value);
    }

    public static long getLong(long address) {
        return unsafe.getLong(address);
    }

    public static void putLong(long address, long value) {
        unsafe.putLong(address, value);
    }

    public static int getInt(long address) {
        return unsafe.getInt(address);
    }

    public static void putInt(long address, int value) {
        unsafe.putInt(address, value);
    }

    public static short getShort(long address) {
        return unsafe.getShort(address);
    }

    public static void putShort(long address, short value) {
        unsafe.putShort(address, value);
    }

    public static void putLong(Object obj, long offset, long value) {
        unsafe.putLong(obj, offset, value);
    }

    public static long getLongVolatile(Object obj, long offset) {
        return unsafe.getLongVolatile(obj, offset);
    }

    public static int getIntVolatile(Object obj, long offset) {
        return unsafe.getIntVolatile(obj, offset);
    }

    public static Object getObjectVolatile(Object obj, long offset) {
        return unsafe.getObjectVolatile(obj, offset);
    }

    public static void putObjectVolatile(Object obj, long offset, Object value) {
        unsafe.putObjectVolatile(obj, offset, value);
    }

    public static int arrayBaseOffset(Class klass) {
        return unsafe.arrayBaseOffset(klass);
    }

    public static int arrayIndexScale(Class klass) {
        int scale = unsafe.arrayIndexScale(klass);
        if (scale == 0) {
            throw new AssertionError((Object)("Array type too narrow for unsafe access: " + klass));
        }
        return scale;
    }

    public static int arrayOffset(int index, int base, int scale) {
        return base + index * scale;
    }

    public static void setMemory(long address, long bytes, byte value) {
        unsafe.setMemory(address, bytes, value);
    }

    public static ByteBuffer newDirectByteBuffer(long addr, int cap) throws Exception {
        if (directByteBufferCtor == null) {
            Object dbb = unsafe.allocateInstance(directByteBufferClass);
            unsafe.putInt(dbb, directByteBufferCapacityOffset, cap);
            unsafe.putInt(dbb, directByteBufferLimitOffset, cap);
            unsafe.putInt(dbb, directByteBufferMarkOffset, -1);
            unsafe.putLong(dbb, directByteBufferAddressOffset, addr);
            return (ByteBuffer)dbb;
        }
        return (ByteBuffer)directByteBufferCtor.newInstance(addr, cap);
    }

    static {
        String arch;
        unsafe = UnsafeUtil.getUnsafe();
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        getAndAddInt = UnsafeUtil.getGetAndAddIntMethodHandle(lookup);
        getAndSetObject = UnsafeUtil.getGetAndSetObjectMethodHandle(lookup);
        Class<?> dbbClass = null;
        Constructor<?> ctor = null;
        long dbbCapacityOffset = 0L;
        long dbbLimitOffset = 0L;
        long dbbMarkOffset = 0L;
        long dbbAddressOffset = 0L;
        try {
            dbbClass = Class.forName("java.nio.DirectByteBuffer");
            Class<?> bufferClass = Class.forName("java.nio.Buffer");
            dbbCapacityOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("capacity"));
            dbbLimitOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("limit"));
            dbbMarkOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("mark"));
            dbbAddressOffset = unsafe.objectFieldOffset(bufferClass.getDeclaredField("address"));
        }
        catch (Throwable e) {
            if (dbbClass == null) {
                throw new LinkageError("Cannot to link java.nio.DirectByteBuffer", e);
            }
            try {
                ctor = dbbClass.getConstructor(Long.TYPE, Integer.TYPE);
                ctor.setAccessible(true);
            }
            catch (NoSuchMethodException e1) {
                throw new LinkageError("Cannot find JNI constructor for java.nio.DirectByteBuffer", e1);
            }
        }
        directByteBufferClass = dbbClass;
        directByteBufferCtor = ctor;
        directByteBufferCapacityOffset = dbbCapacityOffset;
        directByteBufferLimitOffset = dbbLimitOffset;
        directByteBufferMarkOffset = dbbMarkOffset;
        directByteBufferAddressOffset = dbbAddressOffset;
        String alignmentProperty = System.getProperty(allowUnalignedMemoryAccessProperty);
        allowUnalignedMemoryAccess = alignmentProperty != null && (alignmentProperty.equalsIgnoreCase("true") || alignmentProperty.equalsIgnoreCase("false")) ? Boolean.parseBoolean(alignmentProperty) : (arch = System.getProperty("os.arch", "?")).equals("x86_64") || arch.equals("i386") || arch.equals("x86") || arch.equals("amd64");
        storeByteOrderIsNative = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    }
}

