/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import edu.emory.cci.aiw.neo4jetl.Neo4jHome;
import edu.emory.cci.aiw.neo4jetl.config.Configuration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.tooling.GlobalGraphOperations;
import org.protempa.dest.Statistics;
import org.protempa.dest.StatisticsException;

public class Neo4jStatistics
implements Statistics {
    public static final Label NODE_LABEL = DynamicLabel.label((String)"Statistics");
    public static final String TOTAL_KEYS = "numKeys";
    private final Configuration configuration;
    private final File dbPath;

    public Neo4jStatistics(Configuration configuration) throws StatisticsException {
        this.configuration = configuration;
        try {
            Neo4jHome home = new Neo4jHome(this.configuration.getNeo4jHome());
            this.dbPath = home.getDbPath();
        }
        catch (IOException ex) {
            throw new StatisticsException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfKeys() {
        int numberOfKeys;
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseService database = factory.newEmbeddedDatabase(this.dbPath.getAbsolutePath());
        try (Transaction transaction = database.beginTx();){
            try {
                try (ResourceIterator nodeIter = GlobalGraphOperations.at((GraphDatabaseService)database).getAllNodesWithLabel(NODE_LABEL).iterator();){
                    Node node = (Node)nodeIter.next();
                    numberOfKeys = (Integer)node.getProperty(TOTAL_KEYS);
                }
                transaction.success();
            }
            catch (Exception ex) {
                transaction.failure();
                throw ex;
            }
        }
        finally {
            database.shutdown();
        }
        return numberOfKeys;
    }

    public Map<String, Integer> getCounts() {
        return Collections.emptyMap();
    }

    public Map<String, Integer> getCounts(String[] propIds) {
        return Collections.emptyMap();
    }

    public Map<String, String> getChildrenToParents() {
        return Collections.emptyMap();
    }

    public Map<String, String> getChildrenToParents(String[] propIds) {
        return Collections.emptyMap();
    }
}

