/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.arrays;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Arrays {
    private Arrays() {
    }

    public static void matrixCopy(Object[][] src, Object[][] dest) {
        if (src != null && dest != null) {
            for (int i = 0; i < src.length; ++i) {
                System.arraycopy(src[i], 0, dest[i], 0, src[i].length);
            }
        }
    }

    public static void matrixFill(Object[][] matrix, Object val) {
        if (matrix != null) {
            int n = matrix.length;
            for (int i = 0; i < n; ++i) {
                if (matrix[i] == null) continue;
                int m = matrix[i].length;
                for (int j = 0; j < m; ++j) {
                    matrix[i][j] = val;
                }
            }
        }
    }

    public static boolean contains(Object[] arr, Object obj) {
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                Object arri = arr[i];
                if (arri != obj && (arri == null || !arri.equals(obj))) continue;
                return true;
            }
        }
        return false;
    }

    public static <E> Set<E> asSet(E[] objs) {
        HashSet<E> objSet = null;
        if (objs != null) {
            objSet = new HashSet<E>();
            for (E obj : objs) {
                objSet.add(obj);
            }
        }
        return objSet;
    }

    @SafeVarargs
    public static <E> void addAll(Collection<E> collection, E[] ... arr) {
        if (collection == null) {
            throw new IllegalArgumentException("collection cannot be null");
        }
        E[][] EArray = arr;
        int n = EArray.length;
        for (int i = 0; i < n; ++i) {
            E[] oarr;
            for (E o : oarr = EArray[i]) {
                collection.add(o);
            }
        }
    }

    @SafeVarargs
    public static <E> List<E> asList(E[] ... arrs) {
        int size = 0;
        for (E[] arr : arrs) {
            if (arr == null) {
                throw new IllegalArgumentException("Null arrays not allowed");
            }
            size += arr.length;
        }
        ArrayList result = new ArrayList(size);
        Arrays.addAll(result, arrs);
        return result;
    }
}

