/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;

public final class IOUtil {
    private IOUtil() {
    }

    public static String readResourceAsString(Class<?> classObj, String resourceName) throws IOException {
        if (classObj == null) {
            classObj = IOUtil.class;
        }
        if (resourceName == null) {
            return null;
        }
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(classObj.getResourceAsStream(resourceName)));){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    public static List<String> readResourceAsLines(Class<?> classObj, String resourceName) throws IOException {
        InputStream in = IOUtil.getResourceAsStream(resourceName, classObj);
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(in));){
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = buffer.readLine()) != null) {
                lines.add(line);
            }
            ArrayList<String> arrayList = lines;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readPropertiesFromResource(Properties properties, Class<?> classObj, String resourceName) throws IOException {
        if (classObj == null) {
            throw new IllegalArgumentException("classObj cannot be null");
        }
        if (resourceName != null) {
            InputStream inputStream = classObj.getResourceAsStream(resourceName);
            if (inputStream != null) {
                try {
                    properties.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            } else {
                throw new IOException(resourceName + " not found.");
            }
        }
    }

    public static Properties createPropertiesFromResource(Class<?> classObj, String resourceName) throws IOException {
        Properties result = new Properties();
        IOUtil.readPropertiesFromResource(result, classObj, resourceName);
        return result;
    }

    public static String getUserInput(String prompt) throws IOException {
        System.out.print(prompt);
        try (BufferedReader userIn = new BufferedReader(new InputStreamReader(System.in));){
            String string = userIn.readLine();
            return string;
        }
    }

    public static Properties loadPropertiesFromResource(Class<?> cls, String resource) throws IOException {
        return IOUtil.createPropertiesFromResource(cls, resource);
    }

    public static Properties[] loadPropertiesFromResources(Class<?> cls, String[] resources) throws IOException {
        if (resources == null) {
            return null;
        }
        Properties[] result = new Properties[resources.length];
        for (int i = 0; i < resources.length; ++i) {
            result[i] = IOUtil.loadPropertiesFromResource(cls, resources[i]);
        }
        return result;
    }

    public static InputStream getResourceAsStream(String name) throws IOException {
        return IOUtil.getResourceAsStream(name, null);
    }

    public static InputStream getResourceAsStream(String name, Class<?> cls) throws IOException {
        if (cls == null) {
            cls = IOUtil.class;
        }
        if (name == null) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        InputStream result = cls.getResourceAsStream(name);
        if (result == null) {
            throw new IOException("Could not open resource " + name + " using " + cls.getName() + "'s class loader");
        }
        return result;
    }

    public static File resourceToFile(String resourceName, String filePrefix, String fileSuffix) throws IOException {
        int c;
        BufferedReader reader = new BufferedReader(new InputStreamReader(IOUtil.getResourceAsStream(resourceName)));
        File outFile = File.createTempFile(filePrefix, fileSuffix);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(outFile)));
        while ((c = reader.read()) != -1) {
            writer.write(c);
        }
        reader.close();
        writer.close();
        outFile.deleteOnExit();
        return outFile;
    }

    static Logger logger() {
        return LazyLoggerHolder.INSTANCE;
    }

    private static class LazyLoggerHolder {
        private static final Logger INSTANCE = Logger.getLogger(IOUtil.class.getPackage().getName());

        private LazyLoggerHolder() {
        }
    }
}

