/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.io.IOUtil;
import org.arp.javautil.io.Retryable;

public class Retryer<E> {
    private final int retries;
    private final List<E> errors;
    private int attempts;

    public Retryer(int retries) {
        if (retries < 0) {
            throw new IllegalArgumentException("retries must be >= 0");
        }
        this.retries = retries;
        this.errors = new ArrayList();
    }

    public int getRetries() {
        return this.retries;
    }

    public int getAttempts() {
        return this.attempts;
    }

    public List<E> getErrors() {
        return new ArrayList<E>(this.errors);
    }

    public boolean execute(Retryable<E> operation) {
        E error;
        Logger logger = IOUtil.logger();
        int i = this.retries + 1;
        this.attempts = 0;
        this.errors.clear();
        do {
            error = operation.attempt();
            ++this.attempts;
            if (error == null) continue;
            this.errors.add(error);
            this.logError(logger, error, --i);
            if (i <= 0) continue;
            logger.log(Level.WARNING, "Recovering...");
            operation.recover();
        } while (error != null && i > 0);
        return error == null;
    }

    private void logError(Logger logger, E error, int i) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Error occurred: {0}; {1} attempt(s) left", new Object[]{error.toString(), i});
        }
    }
}

