/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.arp.javautil.io.FileUtil;
import org.arp.javautil.io.UniqueDirectoryCreator;

public class TempDirectoryCreator
extends UniqueDirectoryCreator {
    private static final List<File> TEMP_DIRS = new ArrayList<File>();

    @Override
    public File create(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            directory = FileUtil.getTempDirectory();
        }
        File f = super.create(prefix, suffix, directory);
        TEMP_DIRS.add(f);
        return f;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread("TempDirectoryShutdownHook"){

            @Override
            public void run() {
                for (File file : TEMP_DIRS) {
                    try {
                        FileUtil.deleteDirectory(file);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }
}

