/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.serviceloader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class ClassServiceLoader {
    public static <S> List<Class<? extends S>> load(Class<S> service) {
        return ClassServiceLoader.load(service, null);
    }

    public static <S> List<Class<? extends S>> load(Class<S> service, ClassLoader loader) {
        if (loader == null) {
            loader = Thread.currentThread().getContextClassLoader();
        }
        ArrayList<Class<S>> services = new ArrayList<Class<S>>();
        try {
            Enumeration<URL> e = loader.getResources("META-INF/services/" + service.getName());
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                String name = null;
                try (InputStream is = url.openStream();){
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        int comment = line.indexOf(35);
                        if (comment >= 0) {
                            line = line.substring(0, comment);
                        }
                        if ((name = line.trim()).length() == 0) continue;
                        Class<?> clz = Class.forName(name, true, loader);
                        Class<S> impl = clz.asSubclass(service);
                        services.add(impl);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return services;
    }
}

