/*
 * Decompiled with CFR 0.152.
 */
package org.arp.javautil.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.arp.javautil.sql.ConnectionSpec;
import org.arp.javautil.sql.DatabaseProduct;
import org.arp.javautil.sql.DatabaseVersion;
import org.arp.javautil.sql.Driver;
import org.arp.javautil.sql.DriverVersion;

public abstract class AbstractConnectionSpec
implements ConnectionSpec {
    private final boolean autoCommitEnabled;
    private DatabaseProduct databaseProduct;
    private DatabaseVersion databaseVersion;
    private Driver driverName;
    private DriverVersion driverVersion;

    AbstractConnectionSpec(boolean autoCommitEnabled) {
        this.autoCommitEnabled = autoCommitEnabled;
    }

    @Override
    public boolean isAutoCommitEnabled() {
        return this.autoCommitEnabled;
    }

    @Override
    public DatabaseProduct getDatabaseProduct() throws SQLException {
        this.readMetaDataIfNeeded();
        return this.databaseProduct;
    }

    @Override
    public DatabaseVersion getDatabaseVersion() throws SQLException {
        this.readMetaDataIfNeeded();
        return this.databaseVersion;
    }

    @Override
    public Driver getDriver() throws SQLException {
        this.readMetaDataIfNeeded();
        return this.driverName;
    }

    @Override
    public DriverVersion getDriverVersion() throws SQLException {
        this.readMetaDataIfNeeded();
        return this.driverVersion;
    }

    private void readMetaDataIfNeeded() throws SQLException {
        if (this.databaseVersion == null) {
            try (Connection cn = this.getOrCreate();){
                DatabaseMetaData metaData = cn.getMetaData();
                this.databaseProduct = DatabaseProduct.fromMetaData(metaData);
                this.databaseVersion = new DatabaseVersion(metaData);
                this.driverName = Driver.fromMetaData(metaData);
                this.driverVersion = new DriverVersion(metaData);
            }
        }
    }
}

