/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.full;

import java.util.Iterator;
import java.util.Set;
import org.neo4j.consistency.checking.CheckerEngine;
import org.neo4j.consistency.checking.RecordCheck;
import org.neo4j.consistency.checking.full.NodeLabelReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.DiffRecordAccess;
import org.neo4j.consistency.store.RecordAccess;
import org.neo4j.kernel.api.labelscan.LabelScanReader;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public class LabelsMatchCheck
implements RecordCheck<NodeRecord, ConsistencyReport.LabelsMatchReport> {
    private final LabelScanReader labelScanReader;

    public LabelsMatchCheck(LabelScanReader labelScanReader) {
        this.labelScanReader = labelScanReader;
    }

    @Override
    public void check(NodeRecord record, CheckerEngine<NodeRecord, ConsistencyReport.LabelsMatchReport> engine, RecordAccess records) {
        Set<Long> labelsFromNode = NodeLabelReader.getListOfLabels(record, records, engine);
        Iterator labelsFromLabelScanStore = this.labelScanReader.labelsForNode(record.getId());
        while (labelsFromLabelScanStore.hasNext()) {
            labelsFromNode.remove(labelsFromLabelScanStore.next());
        }
        for (Long labelId : labelsFromNode) {
            engine.report().nodeLabelNotInIndex(record, labelId);
        }
    }

    @Override
    public void checkChange(NodeRecord oldRecord, NodeRecord newRecord, CheckerEngine<NodeRecord, ConsistencyReport.LabelsMatchReport> engine, DiffRecordAccess records) {
        this.check(newRecord, engine, (RecordAccess)records);
    }
}

