/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.DbFileSummary;
import com.sleepycat.je.cleaner.LocalUtilizationTracker;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationTracker;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.log.LogContext;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncedLogManager
extends LogManager {
    public SyncedLogManager(EnvironmentImpl envImpl, boolean readOnly) throws DatabaseException {
        super(envImpl, readOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    LogManager.LogWriteInfo serialLog(LogItem item, LogContext context, boolean forceNewLogFile, boolean flushRequired, UtilizationTracker tracker) throws IOException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.serialLogInternal(item, context, forceNewLogFile, flushRequired, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void updateObsolete(LogContext context, UtilizationTracker tracker) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.updateObsoleteInternal(context, tracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushInternal(boolean flushRequired) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            if (!this.logBufferPool.bumpCurrent(0)) {
                this.logBufferPool.bumpAndWriteSynced(0, flushRequired);
                return;
            }
        }
        this.logBufferPool.writeDirty(flushRequired);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TrackedFileSummary getUnflushableTrackedSummary(long file) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.getUnflushableTrackedSummaryInternal(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTrackedFile(TrackedFileSummary tfs) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.removeTrackedFileInternal(tfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteNode(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb, boolean countExact) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteNodeInternal(lsn, type, size, nodeDb, countExact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteNodeDupsAllowed(long lsn, LogEntryType type, int size, DatabaseImpl nodeDb) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteNodeDupsAllowedInternal(lsn, type, size, nodeDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transferToUtilizationTracker(LocalUtilizationTracker localTracker) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.transferToUtilizationTrackerInternal(localTracker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void countObsoleteDb(DatabaseImpl db) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.countObsoleteDbInternal(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeDbFileSummaries(DatabaseImpl db, Collection<Long> fileNums) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return this.removeDbFileSummariesInternal(db, fileNums);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Long, DbFileSummary> cloneDbFileSummaries(DatabaseImpl db) {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            return db.cloneDbFileSummariesInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadEndOfLogStat() {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.loadEndOfLogStatInternal();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetPool(DbConfigManager configManager) throws DatabaseException {
        Latch latch = this.logWriteLatch;
        synchronized (latch) {
            this.logBufferPool.reset(configManager);
        }
    }
}

