/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.index;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TopDocs;
import org.neo4j.collection.primitive.PrimitiveLongSet;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.kernel.api.exceptions.index.IndexCapacityExceededException;
import org.neo4j.kernel.api.impl.index.DirectoryFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterFactory;
import org.neo4j.kernel.api.impl.index.IndexWriterStatus;
import org.neo4j.kernel.api.impl.index.LuceneDocumentStructure;
import org.neo4j.kernel.api.impl.index.LuceneIndexAccessor;
import org.neo4j.kernel.api.impl.index.LuceneUniqueIndexAccessorReader;
import org.neo4j.kernel.api.impl.index.ReservingLuceneIndexWriter;
import org.neo4j.kernel.api.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.NodePropertyUpdate;
import org.neo4j.kernel.api.index.Reservation;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.UniquePropertyIndexUpdater;

class UniqueLuceneIndexAccessor
extends LuceneIndexAccessor
implements UniquePropertyIndexUpdater.Lookup {
    public UniqueLuceneIndexAccessor(LuceneDocumentStructure documentStructure, IndexWriterFactory<ReservingLuceneIndexWriter> indexWriterFactory, IndexWriterStatus writerStatus, DirectoryFactory dirFactory, File dirFile) throws IOException {
        super(documentStructure, indexWriterFactory, writerStatus, dirFactory, dirFile, -1);
    }

    @Override
    public IndexUpdater newUpdater(IndexUpdateMode mode) {
        if (mode != IndexUpdateMode.RECOVERY) {
            return new LuceneUniquePropertyIndexUpdater(super.newUpdater(mode));
        }
        return super.newUpdater(mode);
    }

    @Override
    protected IndexReader makeNewReader(IndexSearcher searcher, Closeable closeable, CancellationRequest cancellation) {
        return new LuceneUniqueIndexAccessorReader(searcher, this.documentStructure, closeable, cancellation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long currentlyIndexedNode(Object value) throws IOException {
        IndexSearcher searcher = (IndexSearcher)this.searcherManager.acquire();
        try {
            TopDocs docs = searcher.search(this.documentStructure.newQuery(value), 1);
            if (docs.scoreDocs.length > 0) {
                Document doc = searcher.getIndexReader().document(docs.scoreDocs[0].doc);
                Long l = this.documentStructure.getNodeId(doc);
                return l;
            }
        }
        finally {
            this.searcherManager.release((Object)searcher);
        }
        return null;
    }

    private class LuceneUniquePropertyIndexUpdater
    extends UniquePropertyIndexUpdater {
        final IndexUpdater delegate;

        public LuceneUniquePropertyIndexUpdater(IndexUpdater delegate) {
            super((UniquePropertyIndexUpdater.Lookup)UniqueLuceneIndexAccessor.this);
            this.delegate = delegate;
        }

        protected void flushUpdates(Iterable<NodePropertyUpdate> updates) throws IOException, IndexEntryConflictException, IndexCapacityExceededException {
            for (NodePropertyUpdate update : updates) {
                this.delegate.process(update);
            }
            this.delegate.close();
        }

        public Reservation validate(Iterable<NodePropertyUpdate> updates) throws IOException, IndexCapacityExceededException {
            return this.delegate.validate(updates);
        }

        public void remove(PrimitiveLongSet nodeIds) throws IOException {
            this.delegate.remove(nodeIds);
        }
    }
}

