/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.common.InternalFactHandle;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.DerivationsBuilder;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.ProtempaUtil;
import org.protempa.SourceSystem;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;

class AbstractionCombinerConsequence
implements Consequence {
    private static final long serialVersionUID = -7984448674528718012L;
    private final DerivationsBuilder derivationsBuilder;

    public AbstractionCombinerConsequence(DerivationsBuilder derivationsBuilder) {
        this.derivationsBuilder = derivationsBuilder;
    }

    public void evaluate(KnowledgeHelper arg0, WorkingMemory arg1) throws Exception {
        InternalFactHandle a1f = arg0.getTuple().get(0);
        AbstractParameter a1 = (AbstractParameter)arg1.getObject((FactHandle)a1f);
        String a1Id = a1.getId();
        InternalFactHandle a2f = arg0.getTuple().get(1);
        AbstractParameter a2 = (AbstractParameter)arg1.getObject((FactHandle)a2f);
        Sequence<AbstractParameter> s = new Sequence<AbstractParameter>(a1Id, 2);
        s.add(a1);
        s.add(a2);
        Segment segment = new Segment(s);
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(arg1, a1Id);
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        AbstractParameter result = new AbstractParameter(a1Id, factory.getInstance());
        result.setSourceSystem(SourceSystem.DERIVED);
        result.setInterval(segment.getInterval());
        result.setValue(a1.getValue());
        result.setCreateDate(new Date());
        Logger logger = ProtempaUtil.logger();
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "Created {0} from {1} and {2}", new Object[]{result, a1, a2});
        }
        arg1.retract((FactHandle)a1f);
        arg1.retract((FactHandle)a2f);
        arg1.insert((Object)result);
        List<Proposition> a1PropBackward = this.derivationsBuilder.propositionRetractedBackward(a1);
        List<Proposition> a2PropBackward = this.derivationsBuilder.propositionRetractedBackward(a2);
        for (Proposition prop : a1PropBackward) {
            this.derivationsBuilder.propositionReplaceForward(prop, a1, result);
            this.derivationsBuilder.propositionAssertedBackward(prop, result);
        }
        for (Proposition prop : a2PropBackward) {
            this.derivationsBuilder.propositionReplaceForward(prop, a2, result);
            this.derivationsBuilder.propositionAssertedBackward(prop, result);
        }
        logger.log(Level.FINER, "Asserted derived proposition {0}", result);
    }
}

