/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.drools.WorkingMemory;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;
import org.protempa.AbstractParameterFactory;
import org.protempa.ClassificationMatrixValue;
import org.protempa.CompoundLowLevelAbstractionDefinition;
import org.protempa.DerivationsBuilder;
import org.protempa.GapFunction;
import org.protempa.JBossRulesDerivedLocalUniqueIdValuesProvider;
import org.protempa.ProtempaUtil;
import org.protempa.SourceSystem;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.AbstractParameterIntervalSectioner;
import org.protempa.proposition.CompoundValuedInterval;
import org.protempa.proposition.ProviderBasedUniqueIdFactory;
import org.protempa.proposition.Segment;
import org.protempa.proposition.Sequence;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Value;

final class CompoundLowLevelAbstractionConsequence
implements Consequence {
    private static final long serialVersionUID = 6456351279290509422L;
    private final CompoundLowLevelAbstractionDefinition cllad;
    private final DerivationsBuilder derivationsBuilder;

    CompoundLowLevelAbstractionConsequence(CompoundLowLevelAbstractionDefinition def, DerivationsBuilder derivationsBuilder) {
        assert (def != null) : "def cannot be null";
        this.cllad = def;
        this.derivationsBuilder = derivationsBuilder;
    }

    private void assertDerivedProposition(WorkingMemory workingMemory, AbstractParameter derived, Set<AbstractParameter> sources) {
        workingMemory.insert((Object)derived);
        for (AbstractParameter parameter : sources) {
            this.derivationsBuilder.propositionAsserted(parameter, derived);
        }
        ProtempaUtil.logger().log(Level.FINER, "Asserted derived proposition {0}", derived);
    }

    public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
        List pl = (List)knowledgeHelper.get(knowledgeHelper.getDeclaration("result"));
        JBossRulesDerivedLocalUniqueIdValuesProvider provider = new JBossRulesDerivedLocalUniqueIdValuesProvider(workingMemory, this.cllad.getPropositionId());
        ProviderBasedUniqueIdFactory factory = new ProviderBasedUniqueIdFactory(provider);
        List intervals = new AbstractParameterIntervalSectioner().buildIntervalList(pl);
        ArrayList<AbstractParameterWithSourceParameters> derivedProps = new ArrayList<AbstractParameterWithSourceParameters>();
        block4: for (CompoundValuedInterval interval : intervals) {
            boolean match = false;
            String lastCheckedValue = null;
            for (Map.Entry<String, List<ClassificationMatrixValue>> e : this.cllad.getValueClassificationsInt().entrySet()) {
                lastCheckedValue = e.getKey();
                switch (this.cllad.getValueDefinitionMatchOperator()) {
                    case ALL: {
                        match = this.allMatch(interval, e.getValue());
                        break;
                    }
                    case ANY: {
                        match = this.anyMatch(interval, e.getValue());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("valueDefinitionMatchStrategy must by ALL or ANY");
                    }
                }
                if (!match) continue;
                AbstractParameter result = CompoundLowLevelAbstractionConsequence.createAbstractParameter(this.cllad.getPropositionId(), NominalValue.getInstance(e.getKey()), interval.getInterval(), this.cllad.getContextId(), factory.getInstance());
                derivedProps.add(new AbstractParameterWithSourceParameters(result, interval.getTemporalPropositions()));
                continue block4;
            }
        }
        if (this.cllad.getMinimumNumberOfValues() <= 1) {
            for (AbstractParameterWithSourceParameters param : derivedProps) {
                this.assertDerivedProposition(workingMemory, param.parameter, param.sourceParameters);
            }
        } else {
            int i = 0;
            while (i < derivedProps.size()) {
                int rhs = this.cllad.getMinimumNumberOfValues() - 1;
                if (i + rhs < derivedProps.size() && this.rangeMatches(derivedProps, i, i + rhs, this.cllad.getGapFunctionBetweenValues())) {
                    Sequence<AbstractParameter> seq = new Sequence<AbstractParameter>(((AbstractParameterWithSourceParameters)derivedProps.get((int)i)).parameter.getId());
                    for (int k = i; k < i + this.cllad.getMinimumNumberOfValues(); ++k) {
                        seq.add(((AbstractParameterWithSourceParameters)derivedProps.get((int)k)).parameter);
                    }
                    Segment seg = new Segment(seq);
                    AbstractParameter result = AbstractParameterFactory.getFromAbstraction(this.cllad.getPropositionId(), factory.getInstance(), seg, null, ((AbstractParameterWithSourceParameters)derivedProps.get((int)i)).parameter.getValue(), null, null, this.cllad.getContextId());
                    this.assertDerivedProposition(workingMemory, result, ((AbstractParameterWithSourceParameters)derivedProps.get((int)i)).sourceParameters);
                }
                if (this.cllad.getSkip() > 0) {
                    i += rhs + this.cllad.getSkip();
                    continue;
                }
                ++i;
            }
        }
    }

    private boolean allMatch(CompoundValuedInterval multiInterval, List<ClassificationMatrixValue> lowLevelValueDefs) {
        return this.match(multiInterval, lowLevelValueDefs, false);
    }

    private boolean anyMatch(CompoundValuedInterval multiInterval, List<ClassificationMatrixValue> lowLevelValueDefs) {
        return this.match(multiInterval, lowLevelValueDefs, true);
    }

    private boolean match(CompoundValuedInterval multiInterval, List<ClassificationMatrixValue> lowLevelValueDefs, boolean bool) {
        for (Map.Entry<String, Value> e : multiInterval.getValues().entrySet()) {
            String id = e.getKey();
            Value val = e.getValue();
            for (ClassificationMatrixValue cmv : lowLevelValueDefs) {
                if (!id.equals(cmv.getPropId()) || val.equals(cmv.getValue()) != bool) continue;
                return bool;
            }
        }
        return !bool;
    }

    private static AbstractParameter createAbstractParameter(String propId, Value value, Interval interval, String contextId, UniqueId uniqueId) {
        AbstractParameter result = new AbstractParameter(propId, uniqueId);
        result.setInterval(interval);
        result.setValue(value);
        result.setSourceSystem(SourceSystem.DERIVED);
        result.setContextId(contextId);
        result.setCreateDate(new Date());
        return result;
    }

    private boolean rangeMatches(List<AbstractParameterWithSourceParameters> propositions, int rangeStart, int rangeEnd, GapFunction gf) {
        Value value = propositions.get((int)rangeStart).parameter.getValue();
        for (int i = rangeStart + 1; i <= rangeEnd; ++i) {
            AbstractParameter prop = propositions.get((int)i).parameter;
            if (value.equals(prop.getValue()) && gf.execute(propositions.get((int)(i - 1)).parameter, prop)) continue;
            return false;
        }
        return true;
    }

    private static final class AbstractParameterWithSourceParameters {
        final AbstractParameter parameter;
        final Set<AbstractParameter> sourceParameters;

        public AbstractParameterWithSourceParameters(AbstractParameter parameter, Set<AbstractParameter> sourcePropositions) {
            this.parameter = parameter;
            this.sourceParameters = sourcePropositions;
        }
    }
}

