/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.SourceSystem;

public final class DataSourceBackendSourceSystem
extends SourceSystem {
    private static final long serialVersionUID = 1L;
    private static Map<String, DataSourceBackendSourceSystem> cache = new HashMap<String, DataSourceBackendSourceSystem>();
    private final String id;

    public static DataSourceBackendSourceSystem getInstance(String id) {
        if (id == null) {
            throw new IllegalArgumentException("id cannot be null");
        }
        DataSourceBackendSourceSystem result = cache.get(id);
        if (result == null) {
            result = new DataSourceBackendSourceSystem(id);
            cache.put(id, result);
        }
        return result;
    }

    private DataSourceBackendSourceSystem(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public String getStringRepresentation() {
        return this.id;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DataSourceBackendSourceSystem other = (DataSourceBackendSourceSystem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.id != null ? this.id.hashCode() : 0);
        return hash;
    }
}

