/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.List;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamerIterator;
import org.protempa.DataStreamerProcessor;
import org.protempa.DataStreamingEventIterator;

final class DataStreamer<E>
implements AutoCloseable {
    private DataStreamerIterator itr;

    DataStreamer() {
    }

    void doStream(DataStreamerProcessor<E> processor, List<DataStreamingEventIterator<E>> itrs) throws DataSourceReadException {
        assert (processor != null) : "processor cannot be null";
        assert (itrs != null) : "itrs cannot be null";
        if (this.itr == null) {
            this.itr = new DataStreamerIterator<E>(itrs);
        }
        boolean stopOnNext = false;
        while (this.itr.hasNext() && !stopOnNext) {
            String keyId = processor.getKeyId();
            String nextKeyId = this.itr.getNextKeyId();
            if (keyId != null && !keyId.equals(nextKeyId)) {
                stopOnNext = true;
            }
            processor.execute(this.itr.next());
        }
        if (!stopOnNext) {
            processor.finish();
        }
    }

    @Override
    public void close() {
        if (this.itr != null) {
            this.itr.close();
        }
    }
}

