/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.List;
import org.protempa.DataSourceReadException;
import org.protempa.DataStreamingEvent;

abstract class DataStreamerProcessor<E> {
    private String currentKeyId;
    private List<E> data = new ArrayList();
    private String keyId;

    protected DataStreamerProcessor() {
    }

    final String getKeyId() {
        return this.keyId;
    }

    final void setKeyId(String keyId) {
        this.keyId = keyId;
    }

    final ExecuteStatus execute(DataStreamingEvent data) throws DataSourceReadException {
        ExecuteStatus result;
        assert (data != null) : "data cannot be null";
        String kId = data.getKeyId();
        if (this.currentKeyId != null && this.checkKeyId(this.currentKeyId) || this.currentKeyId == null && this.checkKeyId(kId)) {
            if (this.currentKeyId != null && !this.currentKeyId.equals(kId)) {
                assert (this.getKeyId() == null || this.currentKeyId.equals(this.getKeyId())) : "inconsistent keyIds " + this.getKeyId() + "; " + this.checkKeyId(this.currentKeyId);
                this.fireKeyCompleted(this.currentKeyId, this.data);
                this.data = new ArrayList();
                result = ExecuteStatus.DID_FIRE;
            } else {
                result = ExecuteStatus.DID_NOT_FIRE_COMPATIBLE;
            }
            this.currentKeyId = kId;
            this.data.addAll(data.getData());
        } else {
            result = ExecuteStatus.DID_NOT_FIRE_WRONG_KEYID;
        }
        return result;
    }

    final boolean finish() throws DataSourceReadException {
        boolean result;
        if (this.currentKeyId != null && this.checkKeyId(this.currentKeyId)) {
            this.fireKeyCompleted(this.currentKeyId, this.data);
            result = true;
        } else {
            result = false;
        }
        this.currentKeyId = null;
        return result;
    }

    final boolean checkKeyId(String keyId) {
        return this.keyId == null || this.keyId.equals(keyId);
    }

    protected abstract void fireKeyCompleted(String var1, List<E> var2) throws DataSourceReadException;

    static enum ExecuteStatus {
        DID_FIRE,
        DID_NOT_FIRE_COMPATIBLE,
        DID_NOT_FIRE_WRONG_KEYID;

    }
}

