/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.AbstractAbstractionDefinition;
import org.protempa.Algorithm;
import org.protempa.AlgorithmInitializationException;
import org.protempa.AlgorithmProcessingException;
import org.protempa.LowLevelAbstractionValueDefinition;
import org.protempa.MinMaxGapBetweenValues;
import org.protempa.ParameterDefinition;
import org.protempa.PatternFinderUser;
import org.protempa.PropositionDefinitionCheckedVisitor;
import org.protempa.PropositionDefinitionVisitor;
import org.protempa.ProtempaException;
import org.protempa.SlidingWindowWidthMode;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.value.Unit;
import org.protempa.proposition.value.ValueType;

public final class LowLevelAbstractionDefinition
extends AbstractAbstractionDefinition
implements PatternFinderUser,
ParameterDefinition {
    private static final long serialVersionUID = -3829737731539676713L;
    private final Set<String> paramIds = new LinkedHashSet<String>(1);
    private Integer minimumDuration = 0;
    private Unit minimumDurationUnits;
    private Integer maximumDuration;
    private Unit maximumDurationUnits;
    private final List<LowLevelAbstractionValueDefinition> valueDefinitions = new ArrayList<LowLevelAbstractionValueDefinition>(3);
    private ValueType valueType = DEFAULT_VALUE_TYPE;
    private String algorithmId;
    private String contextId;
    private int skipStart = -1;
    private int skipEnd = 1;
    private int skip = -1;
    private int maxOverlapping = -1;
    private SlidingWindowWidthMode slidingWindowWidthMode;
    private int maximumNumberOfValues;
    private int minimumNumberOfValues = 1;
    private boolean concatenable = true;
    private final MinMaxGapBetweenValues gapBtwValues = new MinMaxGapBetweenValues();
    private static final ValueType DEFAULT_VALUE_TYPE = ValueType.NOMINALVALUE;

    public LowLevelAbstractionDefinition(String id) {
        super(id);
        this.slidingWindowWidthMode = SlidingWindowWidthMode.ALL;
        this.maximumNumberOfValues = Integer.MAX_VALUE;
    }

    @Override
    public final Integer getMinimumGapBetweenValues() {
        return this.gapBtwValues.getMinimumGapBetweenValues();
    }

    @Override
    public final Unit getMinimumGapBetweenValuesUnits() {
        return this.gapBtwValues.getMinimumGapBetweenValuesUnits();
    }

    @Override
    public final void setMinimumGapBetweenValues(Integer minimumGapBetweenValues) {
        this.gapBtwValues.setMinimumGapBetweenValues(minimumGapBetweenValues);
    }

    @Override
    public final void setMinimumGapBetweenValuesUnits(Unit units) {
        this.gapBtwValues.setMinimumGapBetweenValuesUnits(units);
    }

    @Override
    public final Integer getMaximumGapBetweenValues() {
        return this.gapBtwValues.getMaximumGapBetweenValues();
    }

    @Override
    public final Unit getMaximumGapBetweenValuesUnits() {
        return this.gapBtwValues.getMaximumGapBetweenValuesUnits();
    }

    @Override
    public final void setMaximumGapBetweenValues(Integer maximumGapBetweenValues) {
        this.gapBtwValues.setMaximumGapBetweenValues(maximumGapBetweenValues);
    }

    @Override
    public final void setMaximumGapBetweenValuesUnits(Unit units) {
        this.gapBtwValues.setMaximumGapBetweenValuesUnits(units);
    }

    @Override
    public final void setMaximumNumberOfValues(int l) {
        if (l < 1) {
            throw new IllegalArgumentException("maximumNumberOfValues must be > 0, but was " + l);
        }
        this.maximumNumberOfValues = l;
    }

    @Override
    public final int getMaximumNumberOfValues() {
        return this.maximumNumberOfValues;
    }

    @Override
    public final void setMinimumNumberOfValues(int l) {
        if (l < 1) {
            throw new IllegalArgumentException("minimumNumberOfValues must be > 0, but was " + l);
        }
        this.minimumNumberOfValues = l;
    }

    @Override
    public final int getMinimumNumberOfValues() {
        return this.minimumNumberOfValues;
    }

    @Override
    public final void setSkipStart(int arg) {
        this.skipStart = arg;
    }

    @Override
    public final void unsetSkipStart() {
        this.skipStart = -1;
    }

    @Override
    public final int getSkipStart() {
        return this.skipStart;
    }

    @Override
    public final void setSkipEnd(int arg) {
        this.skipEnd = arg;
    }

    @Override
    public final void unsetSkipEnd() {
        this.skipEnd = -1;
    }

    @Override
    public final int getSkipEnd() {
        return this.skipEnd;
    }

    @Override
    public final void setSkip(int arg) {
        this.skip = arg;
    }

    @Override
    public final void unsetSkip() {
        this.skip = -1;
    }

    @Override
    public final int getSkip() {
        return this.skip;
    }

    @Override
    public final void setMaxOverlapping(int arg) {
        this.maxOverlapping = arg;
    }

    @Override
    public final void unsetMaxOverlapping() {
        this.maxOverlapping = -1;
    }

    @Override
    public final int getMaxOverlapping() {
        return this.maxOverlapping;
    }

    @Override
    public SlidingWindowWidthMode getSlidingWindowWidthMode() {
        return this.slidingWindowWidthMode;
    }

    public void setSlidingWindowWidthMode(SlidingWindowWidthMode slidingWindowWidthMode) {
        if (slidingWindowWidthMode == null) {
            throw new IllegalArgumentException("slidingWindowWidthMode cannot be null");
        }
        if (slidingWindowWidthMode == SlidingWindowWidthMode.DEFAULT && this.algorithmId == null) {
            throw new IllegalArgumentException("slidingWindowWidthMode cannot be DEFAULT when no algorithm has been specified.");
        }
        this.slidingWindowWidthMode = slidingWindowWidthMode;
    }

    public boolean addValueDefinition(LowLevelAbstractionValueDefinition d) {
        return this.valueDefinitions.add(d);
    }

    public List<LowLevelAbstractionValueDefinition> getValueDefinitions() {
        return Collections.unmodifiableList(this.valueDefinitions);
    }

    public LowLevelAbstractionValueDefinition[] getValueDefinitions(String id) {
        ArrayList<LowLevelAbstractionValueDefinition> result = new ArrayList<LowLevelAbstractionValueDefinition>();
        int n = this.valueDefinitions.size();
        for (int i = 0; i < n; ++i) {
            LowLevelAbstractionValueDefinition def = this.valueDefinitions.get(i);
            if (!def.getId().equals(id)) continue;
            result.add(def);
        }
        return result.toArray(new LowLevelAbstractionValueDefinition[result.size()]);
    }

    public boolean addPrimitiveParameterId(String paramId) {
        boolean result = this.paramIds.add(paramId);
        if (result) {
            this.recalculateChildren();
        }
        return result;
    }

    public boolean removePrimitiveParameterId(String paramId) {
        boolean result = this.paramIds.remove(paramId);
        if (result) {
            this.recalculateChildren();
        }
        return result;
    }

    @Override
    public Set<String> getAbstractedFrom() {
        return Collections.unmodifiableSet(this.paramIds);
    }

    public void setValueType(ValueType c) {
        if (c == null) {
            c = DEFAULT_VALUE_TYPE;
        }
        ValueType old = this.valueType;
        this.valueType = c;
        if (this.changes != null) {
            this.changes.firePropertyChange("valueType", (Object)old, (Object)this.valueType);
        }
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public void accept(PropositionDefinitionVisitor processor) {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    @Override
    public void acceptChecked(PropositionDefinitionCheckedVisitor processor) throws ProtempaException {
        if (processor == null) {
            throw new IllegalArgumentException("processor cannot be null.");
        }
        processor.visit(this);
    }

    public final void setMinimumDuration(Integer minDuration) {
        this.minimumDuration = minDuration == null || minDuration.compareTo(0) < 0 ? Integer.valueOf(0) : minDuration;
    }

    public final void setMinimumDurationUnits(Unit minDurationUnits) {
        this.minimumDurationUnits = minDurationUnits;
    }

    public final void setMaximumDuration(Integer maxDuration) {
        this.maximumDuration = maxDuration != null && maxDuration.compareTo(0) < 0 ? Integer.valueOf(0) : maxDuration;
    }

    public final void setMaximumDurationUnits(Unit maxDurationUnits) {
        this.maximumDurationUnits = maxDurationUnits;
    }

    @Override
    public final Integer getMinimumDuration() {
        return this.minimumDuration;
    }

    @Override
    public final Unit getMinimumDurationUnits() {
        return this.minimumDurationUnits;
    }

    @Override
    public final Integer getMaximumDuration() {
        return this.maximumDuration;
    }

    @Override
    public final Unit getMaximumDurationUnits() {
        return this.maximumDurationUnits;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        String old = this.algorithmId;
        this.algorithmId = algorithmId;
        if (this.changes != null) {
            this.changes.firePropertyChange("algorithmId", old, algorithmId);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.setAlgorithmId(null);
        this.paramIds.clear();
        this.minimumDuration = 0;
        this.maximumDuration = null;
        this.valueDefinitions.clear();
        this.setValueType(null);
        this.recalculateChildren();
    }

    private boolean satisfiesGapBetweenValues(Segment<PrimitiveParameter> segment) {
        PrimitiveParameter eprev = (PrimitiveParameter)segment.get(0);
        int n = segment.size();
        for (int i = 1; i < n; ++i) {
            PrimitiveParameter e = (PrimitiveParameter)segment.get(i);
            if (!this.gapBtwValues.satisfiesGap(eprev, e)) {
                return false;
            }
            eprev = e;
        }
        return true;
    }

    final LowLevelAbstractionValueDefinition satisfiedBy(Segment<PrimitiveParameter> segment, Algorithm algorithm) throws AlgorithmInitializationException, AlgorithmProcessingException {
        if (this.satisfiesGapBetweenValues(segment)) {
            for (LowLevelAbstractionValueDefinition valueDef : this.valueDefinitions) {
                if (!valueDef.satisfiedBy(segment, algorithm)) continue;
                return valueDef;
            }
        }
        return null;
    }

    public void setConcatenable(boolean concatenable) {
        this.concatenable = concatenable;
    }

    @Override
    public boolean isConcatenable() {
        return this.concatenable;
    }

    @Override
    public boolean isSolid() {
        return true;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    @Override
    protected void recalculateChildren() {
        String[] old = this.children;
        this.children = this.paramIds.toArray(new String[this.paramIds.size()]);
        if (this.changes != null) {
            this.changes.firePropertyChange("children", old, this.children);
        }
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

