/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.AbstractionDefinition;
import org.protempa.ContextDefinition;
import org.protempa.InvalidPropositionIdException;
import org.protempa.InvalidValueSetDefinitionException;
import org.protempa.PropositionDefinition;
import org.protempa.ProtempaUtil;
import org.protempa.TemporalPropositionDefinition;
import org.protempa.valueset.ValueSet;

final class PropositionDefinitionCache
implements Serializable {
    private static final long serialVersionUID = 5988857805118255882L;
    private Map<String, AbstractionDefinition> idToAbstractionDefinitionMap;
    private Map<String, PropositionDefinition> idToPropositionDefinitionMap;
    private Map<String, ContextDefinition> idToContextDefinitionMap;
    private Map<String, TemporalPropositionDefinition> idToTemporalPropositionDefinitionMap;
    private Map<String, ValueSet> idtoValueSetMap;

    PropositionDefinitionCache() {
        this.initialize();
    }

    private void initialize() {
        this.idToAbstractionDefinitionMap = new HashMap<String, AbstractionDefinition>();
        this.idToPropositionDefinitionMap = new HashMap<String, PropositionDefinition>();
        this.idtoValueSetMap = new HashMap<String, ValueSet>();
        this.idToContextDefinitionMap = new HashMap<String, ContextDefinition>();
        this.idToTemporalPropositionDefinitionMap = new HashMap<String, TemporalPropositionDefinition>();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.idToPropositionDefinitionMap.values());
        s.writeObject(this.idToAbstractionDefinitionMap.values());
        s.writeObject(this.idtoValueSetMap.values());
        s.writeObject(this.idToContextDefinitionMap.values());
        s.writeObject(this.idToTemporalPropositionDefinitionMap.values());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.initialize();
        Collection propositionDefinitions = (Collection)s.readObject();
        Collection abstractionDefinitions = (Collection)s.readObject();
        Collection valueSets = (Collection)s.readObject();
        Collection contextDefinitions = (Collection)s.readObject();
        Collection temporalPropositionDefinitions = (Collection)s.readObject();
        if (propositionDefinitions != null) {
            for (PropositionDefinition def : propositionDefinitions) {
                if (def == null) {
                    throw new InvalidObjectException("Null primitive parameter definition; can't restore");
                }
                try {
                    this.addPropositionDefinition(def);
                }
                catch (InvalidPropositionIdException ex) {
                    String msg = "Could not add de-serialized proposition definition " + def;
                    ProtempaUtil.logger().log(Level.SEVERE, msg, ex);
                    throw new InvalidObjectException(msg);
                }
            }
        } else {
            throw new InvalidObjectException("propositionDefinitions cannot be null");
        }
        if (abstractionDefinitions != null) {
            for (PropositionDefinition def : abstractionDefinitions) {
                if (def == null) {
                    throw new InvalidObjectException("Null abstraction definition; can't restore");
                }
                try {
                    this.addAbstractionDefinition((AbstractionDefinition)def);
                }
                catch (InvalidPropositionIdException ex) {
                    String msg = "Could not add de-serialized abstract parameter definition " + def;
                    ProtempaUtil.logger().log(Level.SEVERE, msg, ex);
                    throw new InvalidObjectException(msg);
                }
            }
        } else {
            throw new InvalidObjectException("abstractionDefinitions cannot be null");
        }
        if (valueSets != null) {
            for (ValueSet valueSet : valueSets) {
                if (valueSet == null) {
                    throw new InvalidObjectException("Null value set; can't restore");
                }
                try {
                    this.addValueSet(valueSet);
                }
                catch (InvalidValueSetDefinitionException ex) {
                    String msg = "Could not add de-serialized value set " + valueSet;
                    ProtempaUtil.logger().log(Level.SEVERE, msg, ex);
                    throw new InvalidObjectException(msg);
                }
            }
        }
        if (temporalPropositionDefinitions != null) {
            for (PropositionDefinition def : contextDefinitions) {
                if (def == null) {
                    throw new InvalidObjectException("Null context definition; can't restore");
                }
                try {
                    this.addContextDefinition((ContextDefinition)def);
                }
                catch (InvalidPropositionIdException ex) {
                    String msg = "Could not add de-serialized context definition " + def;
                    ProtempaUtil.logger().log(Level.SEVERE, msg, ex);
                    throw new InvalidObjectException(msg);
                }
            }
        } else {
            throw new InvalidObjectException("contextDefinitions cannot be null");
        }
        if (temporalPropositionDefinitions != null) {
            for (PropositionDefinition def : temporalPropositionDefinitions) {
                if (def == null) {
                    throw new InvalidObjectException("Null temporalPropositionDefinition; can't restore");
                }
                try {
                    this.addTemporalPropositionDefinition((TemporalPropositionDefinition)def);
                }
                catch (InvalidPropositionIdException ex) {
                    String msg = "Could not add de-serialized temporalPropositionDefinition " + def;
                    ProtempaUtil.logger().log(Level.SEVERE, msg, ex);
                    throw new InvalidObjectException(msg);
                }
            }
        } else {
            throw new InvalidObjectException("temporalPropositionDefinitions cannot be null");
        }
    }

    boolean isUniqueKnowledgeDefinitionObjectId(String id) {
        return !this.idToAbstractionDefinitionMap.containsKey(id) && !this.idToPropositionDefinitionMap.containsKey(id);
    }

    boolean hasPropositionDefinition(String eventId) {
        return this.getPropositionDefinition(eventId) != null;
    }

    boolean hasTemporalPropositionDefinition(String propId) {
        return this.getTemporalPropositionDefinition(propId) != null;
    }

    PropositionDefinition getPropositionDefinition(String propId) {
        return this.idToPropositionDefinitionMap.get(propId);
    }

    TemporalPropositionDefinition getTemporalPropositionDefinition(String propId) {
        return this.idToTemporalPropositionDefinitionMap.get(propId);
    }

    boolean hasValueSet(String valueSetId) {
        return this.getValueSet(valueSetId) != null;
    }

    ValueSet getValueSet(String valueSetId) {
        return this.idtoValueSetMap.get(valueSetId);
    }

    boolean hasAbstractionDefinition(String paramId) {
        return this.getAbstractionDefinition(paramId) != null;
    }

    boolean hasContextDefinition(String contextId) {
        return this.getContextDefinition(contextId) != null;
    }

    AbstractionDefinition getAbstractionDefinition(String paramId) {
        return this.idToAbstractionDefinitionMap.get(paramId);
    }

    ContextDefinition getContextDefinition(String contextId) {
        return this.idToContextDefinitionMap.get(contextId);
    }

    void addPropositionDefinition(PropositionDefinition def) throws InvalidPropositionIdException {
        assert (def != null) : "def cannot be null";
        String id = def.getId();
        if (this.idToPropositionDefinitionMap.containsKey(id)) {
            throw new InvalidPropositionIdException(id);
        }
        this.idToPropositionDefinitionMap.put(id, def);
    }

    void addAbstractionDefinition(AbstractionDefinition def) throws InvalidPropositionIdException {
        assert (def != null) : "def cannot be null";
        String id = def.getId();
        if (this.idToAbstractionDefinitionMap.containsKey(id)) {
            throw new InvalidPropositionIdException(id);
        }
        this.idToAbstractionDefinitionMap.put(id, def);
    }

    void addValueSet(ValueSet valueSet) throws InvalidValueSetDefinitionException {
        assert (valueSet != null) : "valueSet cannot be null";
        String id = valueSet.getId();
        if (this.idtoValueSetMap.containsKey(id)) {
            throw new InvalidValueSetDefinitionException("Duplicate value set id: " + id);
        }
        this.idtoValueSetMap.put(id, valueSet);
    }

    void addContextDefinition(ContextDefinition def) throws InvalidPropositionIdException {
        assert (def != null) : "def cannot be null";
        String id = def.getId();
        if (this.idToContextDefinitionMap.containsKey(id)) {
            throw new InvalidPropositionIdException(id);
        }
        this.idToContextDefinitionMap.put(id, def);
    }

    void addTemporalPropositionDefinition(TemporalPropositionDefinition def) throws InvalidPropositionIdException {
        assert (def != null) : "def cannot be null";
        String id = def.getId();
        if (this.idToTemporalPropositionDefinitionMap.containsKey(id)) {
            throw new InvalidPropositionIdException(id);
        }
        this.idToTemporalPropositionDefinitionMap.put(id, def);
    }

    void clear() {
        this.idToAbstractionDefinitionMap.clear();
        this.idToPropositionDefinitionMap.clear();
        this.idtoValueSetMap.clear();
        this.idToContextDefinitionMap.clear();
        this.idToTemporalPropositionDefinitionMap.clear();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append(this.idToAbstractionDefinitionMap.values()).append(this.idToPropositionDefinitionMap.values()).toString();
    }
}

