/*
 * Decompiled with CFR 0.152.
 */
package org.protempa;

import java.util.Collection;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.protempa.ExtendedPropositionDefinition;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.value.Unit;

public class TemporalExtendedPropositionDefinition
extends ExtendedPropositionDefinition {
    private static final long serialVersionUID = -125025061319511802L;
    private Integer minLength = 0;
    private Unit minLengthUnit;
    private Integer maxLength;
    private Unit maxLengthUnit;

    public TemporalExtendedPropositionDefinition(String propositionId) {
        super(propositionId);
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public Unit getMaxLengthUnit() {
        return this.maxLengthUnit;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = this.maxLength != null && this.maxLength < 0 ? Integer.valueOf(0) : maxLength;
    }

    public void setMaxLengthUnit(Unit units) {
        this.maxLengthUnit = units;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public Unit getMinLengthUnit() {
        return this.minLengthUnit;
    }

    public void setMinLength(Integer minDuration) {
        this.minLength = minDuration == null || minDuration < 0 ? Integer.valueOf(0) : minDuration;
    }

    public void setMinLengthUnit(Unit units) {
        this.minLengthUnit = units;
    }

    @Override
    boolean getMatches(Proposition proposition, Collection<String> propIds) throws KnowledgeSourceReadException {
        if (!super.getMatches(proposition, propIds)) {
            return false;
        }
        if (!(proposition instanceof TemporalProposition)) {
            return false;
        }
        TemporalProposition tp = (TemporalProposition)proposition;
        if (this.minLength != null && tp.getInterval().isLengthLessThan(this.minLength, this.minLengthUnit)) {
            return false;
        }
        return this.maxLength == null || !tp.getInterval().isLengthGreaterThan(this.maxLength, this.maxLengthUnit);
    }

    @Override
    public boolean hasEqualFields(ExtendedPropositionDefinition obj) {
        if (!super.hasEqualFields(obj)) {
            return false;
        }
        if (!(obj instanceof TemporalExtendedPropositionDefinition)) {
            return false;
        }
        TemporalExtendedPropositionDefinition other = (TemporalExtendedPropositionDefinition)obj;
        boolean result = (this.minLength == null ? other.minLength == null : this.minLength == other.minLength || this.minLength.equals(other.minLength)) && (this.minLengthUnit == null ? other.minLengthUnit == null : this.minLengthUnit == other.minLengthUnit || this.minLengthUnit.equals(other.minLengthUnit)) && (this.maxLength == null ? other.maxLength == null : this.maxLength == other.maxLength || this.maxLength.equals(other.maxLength)) && (this.maxLengthUnit == null ? other.maxLengthUnit == null : this.maxLengthUnit == other.maxLengthUnit || this.maxLengthUnit.equals(other.maxLengthUnit));
        return result;
    }

    @Override
    public String toString() {
        return ReflectionToStringBuilder.reflectionToString((Object)this);
    }
}

