/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.protempa.backend.AlgorithmSourceBackendUpdatedEvent;
import org.protempa.backend.Backend;
import org.protempa.backend.BackendInstanceSpec;
import org.protempa.backend.InvalidPropertyNameException;
import org.protempa.backend.InvalidPropertyValueException;
import org.protempa.backend.asb.AlgorithmSourceBackend;
import org.protempa.backend.dsb.DataSourceBackend;
import org.protempa.backend.ksb.KnowledgeSourceBackend;
import org.protempa.backend.tsb.TermSourceBackend;

public class Configuration {
    private String configurationId;
    private List<BackendInstanceSpec<DataSourceBackend>> dataSourceBackendSections = Collections.emptyList();
    private List<BackendInstanceSpec<KnowledgeSourceBackend>> knowledgeSourceBackendSections = Collections.emptyList();
    private List<BackendInstanceSpec<AlgorithmSourceBackend>> algorithmSourceBackendSections = Collections.emptyList();
    private List<BackendInstanceSpec<TermSourceBackend>> termSourceBackendSections = Collections.emptyList();

    public String getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }

    public void setDataSourceBackendSections(List<BackendInstanceSpec<DataSourceBackend>> dataSourceBackendSections) {
        this.dataSourceBackendSections = dataSourceBackendSections != null ? dataSourceBackendSections : Collections.emptyList();
    }

    public void setKnowledgeSourceBackendSections(List<BackendInstanceSpec<KnowledgeSourceBackend>> knowledgeSourceBackendSections) {
        this.knowledgeSourceBackendSections = knowledgeSourceBackendSections != null ? knowledgeSourceBackendSections : Collections.emptyList();
    }

    public void setAlgorithmSourceBackendSections(List<BackendInstanceSpec<AlgorithmSourceBackend>> algorithmSourceBackendSections) {
        this.algorithmSourceBackendSections = algorithmSourceBackendSections != null ? algorithmSourceBackendSections : Collections.emptyList();
    }

    public void setTermSourceBackendSections(List<BackendInstanceSpec<TermSourceBackend>> termSourceBackendSections) {
        this.termSourceBackendSections = termSourceBackendSections != null ? termSourceBackendSections : Collections.emptyList();
    }

    public List<BackendInstanceSpec<DataSourceBackend>> getDataSourceBackendSections() {
        return new ArrayList<BackendInstanceSpec<DataSourceBackend>>(this.dataSourceBackendSections);
    }

    public List<BackendInstanceSpec<KnowledgeSourceBackend>> getKnowledgeSourceBackendSections() {
        return new ArrayList<BackendInstanceSpec<KnowledgeSourceBackend>>(this.knowledgeSourceBackendSections);
    }

    public List<BackendInstanceSpec<AlgorithmSourceBackend>> getAlgorithmSourceBackendSections() {
        return new ArrayList<BackendInstanceSpec<AlgorithmSourceBackend>>(this.algorithmSourceBackendSections);
    }

    public List<BackendInstanceSpec<TermSourceBackend>> getTermSourceBackendSections() {
        return new ArrayList<BackendInstanceSpec<TermSourceBackend>>(this.termSourceBackendSections);
    }

    public List<BackendInstanceSpec<? extends Backend>> getAllSections() {
        ArrayList<BackendInstanceSpec<? extends Backend>> result = new ArrayList<BackendInstanceSpec<? extends Backend>>(this.dataSourceBackendSections.size() + this.knowledgeSourceBackendSections.size() + this.algorithmSourceBackendSections.size() + this.termSourceBackendSections.size());
        result.addAll(this.dataSourceBackendSections);
        result.addAll(this.knowledgeSourceBackendSections);
        result.addAll(this.algorithmSourceBackendSections);
        result.addAll(this.termSourceBackendSections);
        return result;
    }

    public void merge(Configuration otherConfiguration) throws InvalidPropertyNameException, InvalidPropertyValueException {
        if (otherConfiguration != null) {
            BackendInstanceSpec<Backend<AlgorithmSourceBackendUpdatedEvent>> bis;
            BackendInstanceSpec<Backend<AlgorithmSourceBackendUpdatedEvent>> otherBis;
            int i;
            int n = otherConfiguration.algorithmSourceBackendSections.size();
            for (i = 0; i < n; ++i) {
                otherBis = otherConfiguration.algorithmSourceBackendSections.get(i);
                if (this.algorithmSourceBackendSections.size() < i + 1 || !(bis = this.algorithmSourceBackendSections.get(i)).getBackendSpec().getId().equals(otherBis.getBackendSpec().getId())) continue;
                for (String name : otherBis.getPropertyNames()) {
                    bis.setProperty(name, otherBis.getProperty(name));
                }
            }
            n = otherConfiguration.dataSourceBackendSections.size();
            for (i = 0; i < n; ++i) {
                otherBis = otherConfiguration.dataSourceBackendSections.get(i);
                if (this.dataSourceBackendSections.size() < i + 1 || !(bis = this.dataSourceBackendSections.get(i)).getBackendSpec().getId().equals(otherBis.getBackendSpec().getId())) continue;
                for (String name : otherBis.getPropertyNames()) {
                    bis.setProperty(name, otherBis.getProperty(name));
                }
            }
            n = otherConfiguration.knowledgeSourceBackendSections.size();
            for (i = 0; i < n; ++i) {
                otherBis = otherConfiguration.knowledgeSourceBackendSections.get(i);
                if (this.knowledgeSourceBackendSections.size() < i + 1 || !(bis = this.knowledgeSourceBackendSections.get(i)).getBackendSpec().getId().equals(otherBis.getBackendSpec().getId())) continue;
                for (String name : otherBis.getPropertyNames()) {
                    bis.setProperty(name, otherBis.getProperty(name));
                }
            }
            n = otherConfiguration.termSourceBackendSections.size();
            for (i = 0; i < n; ++i) {
                otherBis = otherConfiguration.termSourceBackendSections.get(i);
                if (this.termSourceBackendSections.size() < i + 1 || !(bis = this.termSourceBackendSections.get(i)).getBackendSpec().getId().equals(otherBis.getBackendSpec().getId())) continue;
                for (String name : otherBis.getPropertyNames()) {
                    bis.setProperty(name, otherBis.getProperty(name));
                }
            }
        }
    }
}

