/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.backend.asb.java;

import org.protempa.AbstractAlgorithm;
import org.protempa.AlgorithmArguments;
import org.protempa.AlgorithmParameter;
import org.protempa.Algorithms;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Segment;
import org.protempa.proposition.TemporalParameter;
import org.protempa.proposition.stats.RegressionLine;
import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueType;

public final class TrendAlgorithm
extends AbstractAlgorithm {
    private static final long serialVersionUID = 7080565221625383147L;

    private static double sumDiffY(Segment<PrimitiveParameter> points) {
        double sumDiff = 0.0;
        TemporalParameter p = points.first();
        int n = points.size();
        for (int i = 1; i < n; ++i) {
            TemporalParameter nextp = (TemporalParameter)points.get(i);
            double y = ((NumberValue)p.getValue()).doubleValue();
            double nexty = ((NumberValue)nextp.getValue()).doubleValue();
            sumDiff += Math.abs(y - nexty);
            p = nextp;
        }
        return sumDiff;
    }

    public TrendAlgorithm(Algorithms algorithms, String id) {
        super(algorithms, id);
        this.setParameters(new AlgorithmParameter[]{new AlgorithmParameter("minThreshold", new ValueComparator[]{ValueComparator.LESS_THAN, ValueComparator.LESS_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO, ValueComparator.GREATER_THAN_OR_EQUAL_TO, ValueComparator.GREATER_THAN}, ValueType.NUMERICALVALUE), new AlgorithmParameter("maxThreshold", new ValueComparator[]{ValueComparator.LESS_THAN, ValueComparator.LESS_THAN_OR_EQUAL_TO, ValueComparator.EQUAL_TO, ValueComparator.GREATER_THAN_OR_EQUAL_TO, ValueComparator.GREATER_THAN}, ValueType.NUMERICALVALUE)});
        this.setMinimumNumberOfValues(2);
        this.setMaximumNumberOfValues(2);
    }

    @Override
    public Value compute(Segment<PrimitiveParameter> segment, AlgorithmArguments args) {
        Value minSlopeThreshold = args.value("minThreshold");
        ValueComparator minSlopeThresholdComparator = args.valueComp("minThreshold");
        Value maxSlopeThreshold = args.value("maxThreshold");
        ValueComparator maxSlopeThresholdComparator = args.valueComp("maxThreshold");
        int size = segment.size();
        if (size < 2) {
            return null;
        }
        NumberValue firstValue = (NumberValue)segment.first().getValue();
        NumberValue lastValue = (NumberValue)segment.last().getValue();
        if (firstValue == null || lastValue == null) {
            return null;
        }
        double lastPointY = lastValue.doubleValue();
        RegressionLine line = null;
        try {
            line = new RegressionLine(segment);
        }
        catch (RegressionLine.NullValueException e) {
            return null;
        }
        double avgDiff = TrendAlgorithm.sumDiffY(segment) / (double)(size - 1);
        double firstPointY = firstValue.doubleValue();
        double diffEnds = Math.abs(firstPointY - lastPointY);
        if (avgDiff > 2.0 / (double)size * diffEnds) {
            return null;
        }
        double slopeAsDouble = line.getm();
        if (minSlopeThresholdComparator != null && minSlopeThreshold != null || maxSlopeThresholdComparator != null && maxSlopeThreshold != null) {
            if (Double.isNaN(slopeAsDouble)) {
                return null;
            }
            NumberValue slope = NumberValue.getInstance(slopeAsDouble);
            if (minSlopeThresholdComparator != null && !minSlopeThresholdComparator.compare(slope, minSlopeThreshold) || maxSlopeThresholdComparator != null && !maxSlopeThresholdComparator.compare(slope, maxSlopeThreshold)) {
                return null;
            }
        }
        return BooleanValue.TRUE;
    }
}

