/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.datastore;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eurekaclinical.datastore.BdbMap;
import org.eurekaclinical.datastore.BdbPersistentStoreFactory;
import org.eurekaclinical.datastore.DataStore;
import org.protempa.datastore.AbstractDataStoreCreator;
import org.protempa.datastore.DataStoreUtil;
import org.protempa.proposition.Proposition;

public final class PropositionStoreCreator<P extends Proposition>
extends AbstractDataStoreCreator<String, List<P>> {
    public static final String DATABASE_NAME = "PropositionStore";
    private final BdbPersistentStoreFactory<String, List<P>> storeFactory;
    private int index;

    public PropositionStoreCreator() {
        this(null);
    }

    public PropositionStoreCreator(String environmentName) {
        super(environmentName);
        this.storeFactory = environmentName != null ? new BdbPersistentStoreFactory(environmentName) : null;
    }

    @Override
    public DataStore<String, List<P>> getPersistentStore() {
        if (this.storeFactory == null) {
            throw new IllegalStateException("null environmentName; cannot get a persistent store");
        }
        Logger logger = DataStoreUtil.logger();
        String dbName = this.nextDatabaseName();
        logger.log(Level.FINE, "Getting persistent store {0}", dbName);
        BdbMap store = this.storeFactory.newInstance(dbName);
        logger.log(Level.FINEST, "Got persistent store {0}", dbName);
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String nextDatabaseName() {
        PropositionStoreCreator propositionStoreCreator = this;
        synchronized (propositionStoreCreator) {
            return DATABASE_NAME + this.index++;
        }
    }
}

