/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.dest.proplist;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.arp.javautil.string.StringUtil;
import org.protempa.ProtempaException;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Event;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.visitor.AbstractPropositionCheckedVisitor;

public final class PropositionListQueryResultsHandler
extends AbstractQueryResultsHandler {
    private static final char COLUMN_DELIMITER = '\t';
    private final List<Comparator<Proposition>> comparator;
    private final boolean includeDerived;
    private final TabDelimHandlerPropositionVisitor visitor;

    public PropositionListQueryResultsHandler(BufferedWriter out) {
        this(out, null);
    }

    public PropositionListQueryResultsHandler(BufferedWriter out, boolean includeDerived) {
        this(out, null, includeDerived);
    }

    public PropositionListQueryResultsHandler(BufferedWriter out, List<? extends Comparator<Proposition>> comparator) {
        this(out, comparator, false);
    }

    public PropositionListQueryResultsHandler(BufferedWriter writer, List<? extends Comparator<Proposition>> comparator, boolean includeDerived) {
        this.visitor = new TabDelimHandlerPropositionVisitor(writer);
        this.includeDerived = includeDerived;
        this.comparator = comparator == null ? Collections.emptyList() : new ArrayList<Comparator<Proposition>>(comparator);
    }

    @Override
    public void handleQueryResult(String key, List<Proposition> propositions, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        HashSet<Proposition> propositionsAsSet = new HashSet<Proposition>();
        this.addDerived(propositions, forwardDerivations, backwardDerivations, propositionsAsSet);
        ArrayList<Proposition> propositionsCopy = new ArrayList<Proposition>(propositionsAsSet);
        for (Comparator<Proposition> c : this.comparator) {
            Collections.sort(propositionsCopy, c);
        }
        this.visitor.setKeyId(key);
        try {
            this.visitor.visit(propositionsCopy);
        }
        catch (TabDelimHandlerProtempaException pe) {
            throw new QueryResultsHandlerProcessingException(pe);
        }
        catch (ProtempaException pe) {
            throw new AssertionError((Object)pe);
        }
    }

    private void addDerived(List<Proposition> propositions, Map<Proposition, List<Proposition>> forwardDerivations, Map<Proposition, List<Proposition>> backwardDerivations, Set<Proposition> propositionsAsSet) {
        ArrayList<Proposition> derivedProps = new ArrayList<Proposition>();
        for (Proposition prop : propositions) {
            boolean added = propositionsAsSet.add(prop);
            if (!added || !this.includeDerived) continue;
            derivedProps.addAll((Collection)forwardDerivations.get(prop));
            derivedProps.addAll((Collection)backwardDerivations.get(prop));
            this.addDerived(derivedProps, forwardDerivations, backwardDerivations, propositionsAsSet);
            derivedProps.clear();
        }
    }

    private static final class TabDelimHandlerPropositionVisitor
    extends AbstractPropositionCheckedVisitor {
        private String keyId;
        private final BufferedWriter writer;

        TabDelimHandlerPropositionVisitor(BufferedWriter writer) {
            this.writer = writer;
        }

        void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        @Override
        public void visit(AbstractParameter abstractParameter) throws TabDelimHandlerProtempaException {
            try {
                this.doWriteKeyId();
                this.doWritePropId(abstractParameter);
                this.doWriteValue(abstractParameter);
                this.doWriteTime(abstractParameter);
                this.writer.newLine();
            }
            catch (IOException ioe) {
                throw new TabDelimHandlerProtempaException(ioe);
            }
        }

        @Override
        public void visit(Event event) throws TabDelimHandlerProtempaException {
            try {
                this.doWriteKeyId();
                this.doWritePropId(event);
                this.writer.write(9);
                this.doWriteTime(event);
                this.writer.newLine();
            }
            catch (IOException ioe) {
                throw new TabDelimHandlerProtempaException(ioe);
            }
        }

        @Override
        public void visit(PrimitiveParameter primitiveParameter) throws TabDelimHandlerProtempaException {
            try {
                this.doWriteKeyId();
                this.doWritePropId(primitiveParameter);
                this.doWriteValue(primitiveParameter);
                this.doWriteTime(primitiveParameter);
                this.writer.newLine();
            }
            catch (IOException ioe) {
                throw new TabDelimHandlerProtempaException(ioe);
            }
        }

        @Override
        public void visit(Constant constant) throws TabDelimHandlerProtempaException {
            try {
                this.doWriteKeyId();
                this.doWritePropId(constant);
                this.writer.write(9);
                this.writer.newLine();
            }
            catch (IOException ioe) {
                throw new TabDelimHandlerProtempaException(ioe);
            }
        }

        private void doWriteKeyId() throws IOException {
            StringUtil.escapeAndWriteDelimitedColumn((String)this.keyId, (char)'\t', (Writer)this.writer);
            this.writer.write(9);
        }

        private void doWritePropId(Proposition proposition) throws IOException {
            StringUtil.escapeAndWriteDelimitedColumn((String)proposition.getId(), (char)'\t', (Writer)this.writer);
            this.writer.write(9);
        }

        private void doWriteValue(Parameter parameter) throws IOException {
            StringUtil.escapeAndWriteDelimitedColumn((String)parameter.getValueFormatted(), (char)'\t', (Writer)this.writer);
            this.writer.write(9);
        }

        private void doWriteTime(TemporalProposition proposition) throws IOException {
            StringUtil.escapeAndWriteDelimitedColumn((String)proposition.getStartFormattedShort(), (char)'\t', (Writer)this.writer);
            this.writer.write(9);
            String finish = proposition.getFinishFormattedShort();
            if (!finish.isEmpty()) {
                StringUtil.escapeAndWriteDelimitedColumn((String)finish, (char)'\t', (Writer)this.writer);
            }
        }
    }

    private static final class TabDelimHandlerProtempaException
    extends ProtempaException {
        private static final long serialVersionUID = 2008992530872178708L;

        TabDelimHandlerProtempaException(IOException cause) {
            super(cause);
            assert (cause != null) : "cause cannot be null";
        }
    }
}

