/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.proposition.value;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueBuilder;
import org.protempa.proposition.value.ValueComparator;
import org.protempa.proposition.value.ValueListBuilder;
import org.protempa.proposition.value.ValueType;
import org.protempa.proposition.value.ValueVisitor;

public class ValueList<V extends Value>
extends ArrayList<V>
implements Value {
    private static final long serialVersionUID = -6595541689042779012L;

    public static <V extends Value> ValueList<V> getInstance(V ... value) {
        ValueList<V> result = new ValueList<V>(value.length);
        for (V val : value) {
            result.add(val);
        }
        return result;
    }

    public ValueList(int initialCapacity) {
        super(initialCapacity);
    }

    public ValueList() {
    }

    public ValueList(List<V> values) {
        super(values);
    }

    @Override
    public ValueList<V> replace() {
        return this;
    }

    @Override
    public ValueComparator compare(Value val) {
        if (val == null || val.getType() != ValueType.VALUELIST) {
            return ValueComparator.NOT_EQUAL_TO;
        }
        ValueList vl = (ValueList)val;
        return vl.contains(this) ? ValueComparator.IN : ValueComparator.NOT_IN;
    }

    @Override
    public String getFormatted() {
        ArrayList<String> l = new ArrayList<String>(this.size());
        for (Value val : this) {
            if (val instanceof NominalValue) {
                l.add("'" + val.getFormatted() + "'");
                continue;
            }
            l.add(val.getFormatted());
        }
        return '[' + StringUtils.join(l, (String)", ") + ']';
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public ValueType getType() {
        return ValueType.VALUELIST;
    }

    @Override
    public void accept(ValueVisitor valueVisitor) {
        if (valueVisitor == null) {
            throw new IllegalArgumentException("valueVisitor cannot be null");
        }
        valueVisitor.visit(this);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeInt(this.size());
        for (Object val : this) {
            s.writeObject(val);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        int size = s.readInt();
        for (int i = 0; i < size; ++i) {
            this.add((Value)s.readObject());
        }
    }

    @Override
    public ValueBuilder asBuilder() {
        return new ValueListBuilder(this);
    }
}

