/*
 * Decompiled with CFR 0.152.
 */
package org.protempa.xml;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.AlgorithmSource;
import org.protempa.KnowledgeSource;
import org.protempa.backend.dsb.filter.Filter;
import org.protempa.query.And;
import org.protempa.query.DefaultQueryBuilder;
import org.protempa.query.Query;
import org.protempa.query.QueryBuildException;
import org.protempa.xml.AbstractConverter;
import org.protempa.xml.FiltersConverter;
import org.protempa.xml.PropIDsConverter;
import org.protempa.xml.StringArrayConverter;
import org.protempa.xml.TableQueryResultsHandlerConverter;
import org.protempa.xml.TermIDsConverter;
import org.protempa.xml.XMLConfiguration;

class QueryConverter
extends AbstractConverter {
    private static final String PROPOSITION_IDS = "propositionIDs";
    private static final String KEY_IDS = "keyIDs";
    private static final String KEY_ID = "keyID";
    public static URL querySchemaUrl = null;
    private static Logger myLogger = Logger.getLogger(TableQueryResultsHandlerConverter.class.getName());
    private AlgorithmSource algorithmSource;

    public QueryConverter(KnowledgeSource knowledgeSource, AlgorithmSource algorithmSource) {
        super(knowledgeSource);
        this.algorithmSource = algorithmSource;
    }

    public boolean canConvert(Class clazz) {
        return clazz == Query.class;
    }

    public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
        And<String>[] termIds;
        Query query;
        String[] keyIDs;
        writer.addAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (!XMLConfiguration.isSurpressSchemaReferenceRequested()) {
            writer.addAttribute("xsi:noNamespaceSchemaLocation", QueryConverter.getUrl("query.url").toExternalForm());
        }
        if ((keyIDs = (query = (Query)value).getKeyIds()) != null && keyIDs.length > 0) {
            StringArrayConverter keyIDsConverter = new StringArrayConverter(KEY_ID, this.getKnowledgeSource());
            writer.startNode(KEY_IDS);
            context.convertAnother((Object)keyIDs, (Converter)keyIDsConverter);
            writer.endNode();
        }
        String[] propIDs = query.getPropositionIds();
        PropIDsConverter propIDsConverter = new PropIDsConverter(this.getKnowledgeSource());
        writer.startNode(PROPOSITION_IDS);
        context.convertAnother((Object)propIDs, (Converter)propIDsConverter);
        writer.endNode();
        Filter filters = query.getFilters();
        if (filters != null) {
            FiltersConverter filtersConverter = new FiltersConverter(this.getKnowledgeSource());
            writer.startNode("filters");
            filtersConverter.marshal(filters, writer, context);
            writer.endNode();
        }
        if ((termIds = query.getTermIds()) != null && termIds.length > 0) {
            TermIDsConverter termIDsConverter = new TermIDsConverter(this.getKnowledgeSource());
            writer.startNode("termIDs");
            termIDsConverter.marshal(termIds, writer, context);
            writer.endNode();
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        DefaultQueryBuilder queryBuilder;
        block8: {
            block9: {
                if (!reader.hasMoreChildren()) {
                    throw new ConversionException("protempaQuery element has no children.");
                }
                reader.moveDown();
                queryBuilder = new DefaultQueryBuilder();
                if (KEY_IDS.equals(reader.getNodeName())) {
                    StringArrayConverter keyIDsConverter = new StringArrayConverter(KEY_ID, this.getKnowledgeSource());
                    String[] keyIds = (String[])context.convertAnother(null, String[].class, (Converter)keyIDsConverter);
                    queryBuilder.setKeyIds(keyIds);
                    reader.moveUp();
                    reader.moveDown();
                }
                this.expect(reader, PROPOSITION_IDS);
                PropIDsConverter propIDsConverter = new PropIDsConverter(this.getKnowledgeSource());
                String[] propIds = (String[])context.convertAnother(null, String[].class, (Converter)propIDsConverter);
                queryBuilder.setPropositionIds(propIds);
                reader.moveUp();
                if (!reader.hasMoreChildren()) break block8;
                reader.moveDown();
                if (!reader.getNodeName().equals("filters")) break block9;
                FiltersConverter filtersConverter = new FiltersConverter(this.getKnowledgeSource());
                Filter filters = (Filter)context.convertAnother(null, Filter.class, (Converter)filtersConverter);
                queryBuilder.setFilters(filters);
                reader.moveUp();
                if (!reader.hasMoreChildren()) break block8;
                reader.moveDown();
            }
            if (reader.getNodeName().equals("termIDs")) {
                And<String>[] termIds = this.unmarshalTermIds(reader, context);
                queryBuilder.setTermIds(termIds);
            }
        }
        try {
            return queryBuilder.build(this.getKnowledgeSource(), this.algorithmSource);
        }
        catch (QueryBuildException e) {
            myLogger.log(Level.SEVERE, "Error building query", e);
            return null;
        }
    }

    private And<String>[] unmarshalTermIds(HierarchicalStreamReader reader, UnmarshallingContext context) {
        TermIDsConverter termIDsConverter = new TermIDsConverter(this.getKnowledgeSource());
        return (And[])context.convertAnother(null, And[].class, (Converter)termIDsConverter);
    }

    static URL getQuerySchemaUrl() {
        return QueryConverter.getUrl("query.url");
    }
}

