/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.BinaryHeapQueueAgendaGroup;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleFlowGroupNode;
import org.drools.common.WorkingMemoryAction;
import org.drools.ruleflow.instance.RuleFlowNodeInstance;
import org.drools.ruleflow.instance.impl.RuleFlowSequenceNodeInstanceImpl;
import org.drools.spi.Activation;
import org.drools.util.Iterator;
import org.drools.util.LinkedList;

public class RuleFlowGroupImpl
extends RuleFlowSequenceNodeInstanceImpl
implements InternalRuleFlowGroup {
    private static final long serialVersionUID = 400L;
    private InternalWorkingMemory workingMemory;
    private final String name;
    private boolean active = false;
    private final LinkedList list;
    private boolean autoDeactivate = true;

    public RuleFlowGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
    }

    public String getName() {
        return this.name;
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            if (this.list.isEmpty()) {
                if (this.autoDeactivate) {
                    DeactivateCallback action = new DeactivateCallback(this);
                    this.workingMemory.queueWorkingMemoryAction(action);
                }
            } else {
                this.triggerActivations();
            }
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireRuleFlowGroupActivated(this, this.workingMemory);
        } else {
            Iterator it = this.list.iterator();
            RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
            while (node != null) {
                Activation activation = node.getActivation();
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                node = (RuleFlowGroupNode)it.next();
            }
            if (this.getProcessInstance() != null) {
                this.triggerCompleted();
            }
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireRuleFlowGroupDeactivated(this, this.workingMemory);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
        if (autoDeactivate && this.active && this.list.isEmpty()) {
            this.active = false;
        }
    }

    private void triggerActivations() {
        Iterator it = this.list.iterator();
        RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
        while (node != null) {
            Activation activation = node.getActivation();
            ((BinaryHeapQueueAgendaGroup)activation.getAgendaGroup()).add(activation);
            node = (RuleFlowGroupNode)it.next();
        }
    }

    public void clear() {
        this.list.clear();
    }

    public int size() {
        return this.list.size();
    }

    public void addActivation(Activation activation) {
        RuleFlowGroupNode node = new RuleFlowGroupNode(activation, this);
        activation.setRuleFlowGroupNode(node);
        this.list.add(node);
        if (this.active) {
            ((InternalAgendaGroup)activation.getAgendaGroup()).add(activation);
        }
    }

    public void removeActivation(Activation activation) {
        RuleFlowGroupNode node = activation.getRuleFlowGroupNode();
        this.list.remove(node);
        activation.setActivationGroupNode(null);
        if (this.active && this.autoDeactivate && this.list.isEmpty()) {
            DeactivateCallback action = new DeactivateCallback(this);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public java.util.Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    public String toString() {
        return "RuleFlowGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof RuleFlowGroupImpl)) {
            return false;
        }
        return ((RuleFlowGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void trigger(RuleFlowNodeInstance parent) {
        this.setActive(true);
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private final InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }
    }
}

