/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel;

import java.io.IOException;
import org.neo4j.helpers.collection.Visitor;
import org.neo4j.kernel.impl.transaction.log.LogRecoveryCheck;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Recovery
extends LifecycleAdapter {
    private final SPI spi;
    private final Monitor monitor;
    private boolean recoveredLog = false;

    public Recovery(SPI spi, Monitor monitor) {
        this.spi = spi;
        this.monitor = monitor;
    }

    @Override
    public void init() throws Throwable {
        long recoveryVersion = this.spi.getCurrentLogVersion();
        try (LogVersionedStoreChannel toRecover = this.spi.getLogFile(recoveryVersion);){
            if (LogRecoveryCheck.recoveryRequired(toRecover)) {
                this.monitor.recoveryRequired(toRecover.getVersion());
                this.spi.getRecoverer().visit(toRecover);
                this.recoveredLog = true;
                this.monitor.logRecovered();
                this.spi.forceEverything();
            }
        }
    }

    @Override
    public void start() throws Throwable {
        if (this.recoveredLog) {
            this.monitor.recoveryCompleted();
        }
    }

    public static interface SPI {
        public void forceEverything();

        public long getCurrentLogVersion();

        public Visitor<LogVersionedStoreChannel, IOException> getRecoverer();

        public LogVersionedStoreChannel getLogFile(long var1) throws IOException;
    }

    public static interface Monitor {
        public void recoveryRequired(long var1);

        public void logRecovered();

        public void recoveryCompleted();
    }
}

