/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.standard;

import java.io.IOException;
import org.neo4j.kernel.impl.store.format.Store;
import org.neo4j.kernel.impl.store.standard.StoreIdGenerator;
import org.neo4j.kernel.impl.store.standard.StoreToolkit;

public interface IdGeneratorRebuilder {
    public void rebuildIdGenerator() throws IOException;

    public static class FullDefragmentationRebuilderFactory
    implements Factory {
        @Override
        public IdGeneratorRebuilder newIdGeneratorRebuilder(final Store<?, ?> store, final StoreToolkit toolkit, final StoreIdGenerator idGenerator) {
            return new IdGeneratorRebuilder(){

                @Override
                public void rebuildIdGenerator() throws IOException {
                    new FindHighestInUseRebuilderFactory().newIdGeneratorRebuilder(store, toolkit, idGenerator).rebuildIdGenerator();
                    long highId = idGenerator.highestIdInUse();
                    try (Object cursor = store.cursor(1);){
                        long currentId = toolkit.firstRecordId();
                        while (currentId < highId && cursor.position(currentId++)) {
                            boolean inUse;
                            do {
                                inUse = cursor.inUse();
                            } while (cursor.shouldRetry());
                            if (inUse) continue;
                            idGenerator.free(cursor.recordId());
                        }
                    }
                }
            };
        }
    }

    public static class FindHighestInUseRebuilderFactory
    implements Factory {
        @Override
        public IdGeneratorRebuilder newIdGeneratorRebuilder(final Store<?, ?> store, final StoreToolkit toolkit, final StoreIdGenerator idGenerator) {
            return new IdGeneratorRebuilder(){

                @Override
                public void rebuildIdGenerator() throws IOException {
                    try (Object cursor = store.cursor(3);){
                        cursor.position(toolkit.fileSize() / (long)toolkit.recordSize() + 1L);
                        cursor.next();
                        idGenerator.rebuild(Math.max(cursor.recordId(), toolkit.firstRecordId()));
                    }
                }
            };
        }
    }

    public static interface Factory {
        public IdGeneratorRebuilder newIdGeneratorRebuilder(Store<?, ?> var1, StoreToolkit var2, StoreIdGenerator var3);
    }
}

