/*
 * Decompiled with CFR 0.152.
 */
package org.mvel.ast;

import java.util.List;
import org.mvel.ASTNode;
import org.mvel.ast.cache.CachedListAccessor;
import org.mvel.integration.VariableResolverFactory;
import org.mvel.optimizers.AccessorOptimizer;
import org.mvel.optimizers.OptimizerFactory;

public class InlineCollectionNode
extends ASTNode {
    public InlineCollectionNode(char[] expr, int start, int end, int fields) {
        super(expr, start, end, fields | 0x8000);
    }

    public InlineCollectionNode(char[] expr, int fields) {
        super(expr, fields);
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        if (this.accessor != null) {
            return this.accessor.getValue(ctx, thisValue, factory);
        }
        AccessorOptimizer ao = OptimizerFactory.getDefaultAccessorCompiler();
        this.accessor = ao.optimizeCollection(this.name, ctx, thisValue, factory);
        this.egressType = ao.getEgressType();
        if (ao.isLiteralOnly()) {
            Class<?> clazz;
            try {
                clazz = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            if (this.egressType == clazz) {
                List v = (List)this.accessor.getValue(null, null, null);
                this.accessor = new CachedListAccessor(v);
                return v;
            }
        }
        return this.accessor.getValue(ctx, thisValue, factory);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return OptimizerFactory.getAccessorCompiler(OptimizerFactory.SAFE_REFLECTIVE).optimizeCollection(this.name, ctx, thisValue, factory).getValue(ctx, thisValue, factory);
    }
}

