/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.datastore;

import com.sleepycat.je.Environment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arp.javautil.io.FileUtil;
import org.eurekaclinical.datastore.DataStoreUtil;
import org.eurekaclinical.datastore.EnvironmentInfo;

public final class BdbStoreShutdownHook
extends Thread {
    private final List<EnvironmentInfo> envInfos = new ArrayList<EnvironmentInfo>();
    private final boolean deleteOnExit;

    BdbStoreShutdownHook(boolean deleteOnExit) {
        this.deleteOnExit = deleteOnExit;
    }

    void addEnvironmentInfo(EnvironmentInfo environmentInfo) {
        this.envInfos.add(environmentInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws IOException {
        BdbStoreShutdownHook bdbStoreShutdownHook = this;
        synchronized (bdbStoreShutdownHook) {
            for (EnvironmentInfo envInfo : this.envInfos) {
                envInfo.getClassCatalog().close();
                envInfo.closeAndRemoveAllDatabaseHandles();
                Environment env = envInfo.getEnvironment();
                Throwable throwable = null;
                try {
                    if (!this.deleteOnExit) continue;
                    FileUtil.deleteDirectory((File)env.getHome());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (env == null) continue;
                    if (throwable != null) {
                        try {
                            env.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    env.close();
                }
            }
            this.envInfos.clear();
        }
    }

    @Override
    public void run() {
        try {
            this.shutdown();
        }
        catch (IOException ex) {
            Logger logger = DataStoreUtil.logger();
            logger.log(Level.SEVERE, "Error during shutdown", ex);
        }
    }
}

