/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveIntSet;
import org.neo4j.collection.primitive.PrimitiveIntVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractIntHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveIntHashSet
extends AbstractIntHopScotchCollection<Object>
implements PrimitiveIntSet {
    private final Object valueMarker;
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveIntHashSet(Table<Object> table, Object valueMarker, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.valueMarker = valueMarker;
        this.monitor = monitor;
    }

    @Override
    public boolean add(int value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value, this.valueMarker, this) == null;
    }

    @Override
    public boolean addAll(PrimitiveIntIterator values) {
        boolean changed = false;
        while (values.hasNext()) {
            changed |= HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, values.next(), this.valueMarker, this) == null;
        }
        return changed;
    }

    @Override
    public boolean contains(int value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean accept(int value) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean remove(int value) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, value) == this.valueMarker;
    }

    @Override
    public boolean equals(Object other) {
        if (this.typeAndSizeEqual(other)) {
            PrimitiveIntHashSet that = (PrimitiveIntHashSet)other;
            IntKeyEquality equality = new IntKeyEquality(that);
            this.visitKeys(equality);
            return equality.isEqual();
        }
        return false;
    }

    @Override
    public int hashCode() {
        HashCodeComputer hash = new HashCodeComputer();
        this.visitKeys(hash);
        return hash.hashCode();
    }

    private static class HashCodeComputer
    implements PrimitiveIntVisitor<RuntimeException> {
        private int hash = 1337;

        private HashCodeComputer() {
        }

        @Override
        public boolean visited(int value) throws RuntimeException {
            this.hash += HopScotchHashingAlgorithm.DEFAULT_HASHING.hash(value);
            return false;
        }

        public int hashCode() {
            return this.hash;
        }
    }

    private static class IntKeyEquality
    implements PrimitiveIntVisitor<RuntimeException> {
        private PrimitiveIntHashSet other;
        private boolean equal = true;

        public IntKeyEquality(PrimitiveIntHashSet that) {
            this.other = that;
        }

        @Override
        public boolean visited(int value) {
            this.equal = this.other.contains(value);
            return !this.equal;
        }

        public boolean isEqual() {
            return this.equal;
        }
    }
}

