/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import edu.emory.cci.aiw.neo4jetl.RawValueVisitor;
import edu.emory.cci.aiw.neo4jetl.config.Configuration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.protempa.ParameterDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.proposition.AbstractParameter;
import org.protempa.proposition.Constant;
import org.protempa.proposition.Context;
import org.protempa.proposition.Event;
import org.protempa.proposition.Parameter;
import org.protempa.proposition.PrimitiveParameter;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.TemporalProposition;
import org.protempa.proposition.interval.Interval;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueVisitor;
import org.protempa.proposition.visitor.PropositionVisitor;

class MapPropositionVisitor
implements PropositionVisitor {
    private final Map<String, Object> map = new HashMap<String, Object>();
    private final Configuration configuration;
    private final PropositionDefinitionCache cache;

    MapPropositionVisitor(Configuration configuration, PropositionDefinitionCache cache) {
        this.configuration = configuration;
        this.cache = cache;
    }

    public void visit(Map<String, List<Proposition>> finderResult) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public void visit(Collection<? extends Proposition> propositions) {
        throw new UnsupportedOperationException("Not supported yet");
    }

    public void visit(PrimitiveParameter primitiveParameter) {
        this.handleTemporal((TemporalProposition)primitiveParameter);
        this.map.put("position", primitiveParameter.getPosition());
        this.map.put("position_tval", primitiveParameter.getPositionFormattedShort());
        this.handleValue((Parameter)primitiveParameter);
        this.handleCommon((Proposition)primitiveParameter);
    }

    public void visit(Event event) {
        this.handleTemporal((TemporalProposition)event);
        this.handleCommon((Proposition)event);
    }

    public void visit(AbstractParameter abstractParameter) {
        this.handleTemporal((TemporalProposition)abstractParameter);
        this.handleValue((Parameter)abstractParameter);
        this.handleCommon((Proposition)abstractParameter);
    }

    public void visit(Constant constant) {
        this.handleCommon((Proposition)constant);
    }

    public void visit(Context context) {
        this.handleCommon((Proposition)context);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    private void handleCommon(Proposition inProposition) {
        for (String s : inProposition.getPropertyNames()) {
            Value v = inProposition.getProperty(s);
            if (v != null) {
                RawValueVisitor visitor = new RawValueVisitor();
                v.accept((ValueVisitor)visitor);
                this.map.put(s, visitor.getValue());
                continue;
            }
            this.map.put(s, this.configuration.getNullValue());
        }
    }

    private void handleTemporal(TemporalProposition tempProp) {
        Interval interval = tempProp.getInterval();
        this.map.put("length", interval.getMinLength());
        this.map.put("lengthUnit", tempProp.getLengthFormattedShort());
        this.map.put("start", interval.getMinStart());
        this.map.put("start_tval", tempProp.getStartFormattedShort());
        this.map.put("finish", interval.getMinFinish());
        this.map.put("finish_tval", tempProp.getFinishFormattedShort());
    }

    private void handleValue(Parameter param) {
        Value value = param.getValue();
        if (value != null) {
            RawValueVisitor visitor = new RawValueVisitor();
            value.accept((ValueVisitor)visitor);
            this.map.put("value", visitor.getValue());
            this.map.put("value_tval", value.getFormatted());
            this.map.put("valueType", value.getType().name());
        } else {
            this.map.put("value", this.configuration.getNullValue());
            this.map.put("value_tval", this.configuration.getNullValue());
            this.map.put("valueType", ((ParameterDefinition)this.cache.get(param.getId())).getValueType().name());
        }
    }
}

