/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import edu.emory.cci.aiw.neo4jetl.CommandFailedException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecuteResultHandler;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteResultHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Neo4jHome {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jHome.class);
    private static final String SERVER_PROPERTIES = new File("conf", "neo4j-server.properties").getPath();
    private static final String SERVER_CONTROL_COMMAND = new File("bin", "neo4j").getPath();
    private final String home;
    private final File dbPath;

    Neo4jHome(String home) throws IOException {
        assert (home != null) : "home cannot be null";
        this.home = home;
        Properties serverProperties = new Properties();
        try (FileReader bf = new FileReader(new File(home, SERVER_PROPERTIES));){
            serverProperties.load(bf);
        }
        this.dbPath = new File(home, serverProperties.getProperty("org.neo4j.server.database.location"));
    }

    File getDbPath() {
        return this.dbPath;
    }

    void startServer() throws IOException, InterruptedException, CommandFailedException {
        this.controlServer("start");
    }

    void stopServer() throws IOException, InterruptedException, CommandFailedException {
        this.controlServer("stop");
    }

    private void controlServer(String command) throws IOException, InterruptedException, CommandFailedException {
        LOGGER.debug("Executing neo4j command {}...", (Object)command);
        CommandLine serverControlCommand = new CommandLine(new File(this.home, SERVER_CONTROL_COMMAND));
        serverControlCommand.addArgument("${command}");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("command", command);
        serverControlCommand.setSubstitutionMap(map);
        DefaultExecuteResultHandler resultHandler = new DefaultExecuteResultHandler();
        ExecuteWatchdog watchdog = new ExecuteWatchdog(60000L);
        DefaultExecutor executor = new DefaultExecutor();
        executor.setExitValue(1);
        executor.setWatchdog(watchdog);
        executor.execute(serverControlCommand, (ExecuteResultHandler)resultHandler);
        LOGGER.debug("Neo4j command {} is completed, checking exit value...", (Object)command);
        resultHandler.waitFor();
        int exitValue = resultHandler.getExitValue();
        if (exitValue != 0) {
            ExecuteException exception = resultHandler.getException();
            throw new CommandFailedException(exitValue, "Neo4j command '" + command + "' failed", (Throwable)exception);
        }
        LOGGER.debug("Neo4j command {} was successful", (Object)command);
    }
}

