/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import edu.emory.cci.aiw.neo4jetl.Neo4jQueryResultsHandlerWrapped;
import edu.emory.cci.aiw.neo4jetl.config.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.SynchronousQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.protempa.DataSource;
import org.protempa.PropositionDefinitionCache;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.QueryResultsHandlerValidationFailedException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.query.Query;

public class Neo4jQueryResultsHandler
extends AbstractQueryResultsHandler {
    private static final Logger LOGGER = Logger.getLogger(Neo4jQueryResultsHandler.class.getName());
    private final Neo4jQueryResultsHandlerWrapped wrapped;
    private final SynchronousQueue startSynchronousQueue;
    private final SynchronousQueue endSynchronousQueue;
    private final Object handoffObject;
    private volatile PropositionDefinitionCache cache;
    private volatile boolean processing;
    private volatile String keyId;
    private volatile List<Proposition> propositions;
    private volatile Map<Proposition, Set<Proposition>> forwardDerivations;
    private volatile Map<Proposition, Set<Proposition>> backwardDerivations;
    private volatile Map<UniqueId, Proposition> references;
    private volatile boolean hasPassedAfterStart;
    private final Thread wrappedThread;
    private volatile QueryResultsHandlerProcessingException exception;
    private volatile boolean atEnd;
    private final Query query;
    private final String id;

    Neo4jQueryResultsHandler(Query inQuery, DataSource dataSource, Configuration configuration) throws QueryResultsHandlerInitException {
        assert (configuration != null) : "configuration cannot be null";
        assert (inQuery != null) : "inQuery cannot be null";
        assert (dataSource != null) : "dataSource cannot be null";
        this.wrapped = new Neo4jQueryResultsHandlerWrapped(inQuery, dataSource, configuration);
        this.id = configuration.getName();
        this.startSynchronousQueue = new SynchronousQueue();
        this.endSynchronousQueue = new SynchronousQueue();
        this.handoffObject = new Object();
        this.wrappedThread = new Thread(){

            @Override
            public void run() {
                try {
                    Neo4jQueryResultsHandler.this.startSynchronousQueue.take();
                    this.doStart();
                    Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                    Neo4jQueryResultsHandler.this.startSynchronousQueue.take();
                    Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                    while (true) {
                        Neo4jQueryResultsHandler.this.startSynchronousQueue.take();
                        if (!Neo4jQueryResultsHandler.this.processing) break;
                        this.doHandleQueryResult();
                        Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                    }
                    this.doFinish();
                    Neo4jQueryResultsHandler.this.atEnd = true;
                    Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                }
                catch (QueryResultsHandlerProcessingException ex) {
                    Neo4jQueryResultsHandler.this.exception = ex;
                    Neo4jQueryResultsHandler.this.atEnd = true;
                    try {
                        Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (InterruptedException ex) {
                    LOGGER.log(Level.FINE, "Result processing interrupted", ex);
                    Neo4jQueryResultsHandler.this.atEnd = true;
                    try {
                        Neo4jQueryResultsHandler.this.endSynchronousQueue.put(Neo4jQueryResultsHandler.this.handoffObject);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }

            private void doStart() throws QueryResultsHandlerProcessingException {
                Neo4jQueryResultsHandler.this.wrapped.start(Neo4jQueryResultsHandler.this.cache);
            }

            private void doHandleQueryResult() throws QueryResultsHandlerProcessingException {
                Neo4jQueryResultsHandler.this.wrapped.handleQueryResult(Neo4jQueryResultsHandler.this.keyId, Neo4jQueryResultsHandler.this.propositions, Neo4jQueryResultsHandler.this.forwardDerivations, Neo4jQueryResultsHandler.this.backwardDerivations, Neo4jQueryResultsHandler.this.references);
            }

            private void doFinish() throws QueryResultsHandlerProcessingException {
                Neo4jQueryResultsHandler.this.wrapped.finish();
            }
        };
        this.wrappedThread.start();
        this.query = inQuery;
    }

    public String getId() {
        return this.id != null ? this.id : super.getId();
    }

    public void validate() throws QueryResultsHandlerValidationFailedException {
        this.wrapped.validate();
    }

    public void start(PropositionDefinitionCache cache) throws QueryResultsHandlerProcessingException {
        this.cache = cache;
        this.processing = true;
        this.hasPassedAfterStart = false;
        try {
            this.doExecuteStep();
            this.doCheckForException();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Data processing interrupted", ex);
        }
    }

    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        try {
            this.doPassAfterStartIfNeeded();
            this.keyId = keyId;
            this.propositions = propositions;
            this.forwardDerivations = forwardDerivations;
            this.backwardDerivations = backwardDerivations;
            this.references = references;
            this.doExecuteStep();
            this.doCheckForException();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Data processing interrupted", ex);
        }
    }

    public void finish() throws QueryResultsHandlerProcessingException {
        LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler finishing up for query {0}...", this.query.getName());
        try {
            this.processing = false;
            this.doGoToEnd();
            this.doCheckForException();
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Data processing interrupted", ex);
        }
        LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler finished up for query {0}...", this.query.getName());
    }

    public void close() throws QueryResultsHandlerCloseException {
        LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler closing for query {0}...", this.query.getName());
        this.processing = false;
        if (!this.atEnd) {
            try {
                this.doGoToEnd();
            }
            catch (InterruptedException ex) {
                LOGGER.log(Level.FINE, "Data processing interrupted", ex);
            }
        }
        try {
            LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler waiting for results handling thread to end for query {0}", this.query.getName());
            this.wrappedThread.join();
            LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler results handling thread for query {0} is finished", this.query.getName());
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.FINE, "Data processing interrupted", ex);
        }
        boolean thrown = true;
        try {
            this.doCheckForException();
            thrown = false;
        }
        catch (QueryResultsHandlerProcessingException ex) {
            throw new QueryResultsHandlerCloseException((Throwable)ex);
        }
        finally {
            block15: {
                try {
                    this.wrapped.close();
                }
                catch (QueryResultsHandlerCloseException ex) {
                    if (thrown) break block15;
                    throw ex;
                }
            }
        }
        LOGGER.log(Level.FINE, "Neo4jQueryResultsHandler closed for query {0}", this.query.getName());
    }

    public void cancel() {
        this.wrappedThread.interrupt();
    }

    private void doGoToEnd() throws InterruptedException {
        this.doPassAfterStartIfNeeded();
        this.doExecuteStep();
    }

    private void doExecuteStep() throws InterruptedException {
        this.startSynchronousQueue.put(this.handoffObject);
        this.endSynchronousQueue.take();
    }

    private void doPassAfterStartIfNeeded() throws InterruptedException {
        if (!this.hasPassedAfterStart) {
            this.doExecuteStep();
            this.hasPassedAfterStart = true;
        }
    }

    private void doCheckForException() throws QueryResultsHandlerProcessingException {
        if (this.exception != null) {
            QueryResultsHandlerProcessingException throwable = this.exception;
            this.exception = null;
            throw throwable;
        }
    }
}

