/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import edu.emory.cci.aiw.neo4jetl.CommandFailedException;
import edu.emory.cci.aiw.neo4jetl.Derivations;
import edu.emory.cci.aiw.neo4jetl.MapPropositionVisitor;
import edu.emory.cci.aiw.neo4jetl.Neo4jHome;
import edu.emory.cci.aiw.neo4jetl.Neo4jStatistics;
import edu.emory.cci.aiw.neo4jetl.PropositionDefinitionRelationBackwardVisitor;
import edu.emory.cci.aiw.neo4jetl.PropositionDefinitionRelationForwardVisitor;
import edu.emory.cci.aiw.neo4jetl.PropositionDefinitionRelationVisitor;
import edu.emory.cci.aiw.neo4jetl.config.Configuration;
import edu.emory.cci.aiw.neo4jetl.config.IndexOnProperty;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.MultipleFoundException;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.collection.IteratorUtil;
import org.protempa.DataSource;
import org.protempa.DataSourceReadException;
import org.protempa.KnowledgeSourceReadException;
import org.protempa.PropositionDefinition;
import org.protempa.PropositionDefinitionCache;
import org.protempa.PropositionDefinitionCheckedVisitor;
import org.protempa.ProtempaException;
import org.protempa.dest.AbstractQueryResultsHandler;
import org.protempa.dest.QueryResultsHandlerCloseException;
import org.protempa.dest.QueryResultsHandlerInitException;
import org.protempa.dest.QueryResultsHandlerProcessingException;
import org.protempa.dest.QueryResultsHandlerValidationFailedException;
import org.protempa.proposition.Proposition;
import org.protempa.proposition.UniqueId;
import org.protempa.proposition.visitor.PropositionVisitor;
import org.protempa.query.Query;
import org.protempa.query.QueryMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jQueryResultsHandlerWrapped
extends AbstractQueryResultsHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(Neo4jQueryResultsHandlerWrapped.class);
    public static final Label NODE_LABEL = DynamicLabel.label((String)"Data");
    public static final int DEFAULT_COMMIT_FREQUENCY = 2000;
    private final Map<UniqueId, Node> nodes = new HashMap<UniqueId, Node>();
    private final Map<String, RelationshipType> relations = new HashMap<String, RelationshipType>();
    private final Map<String, Derivations.Type> deriveType = new HashMap<String, Derivations.Type>();
    private final Query query;
    private GraphDatabaseService db;
    private PropositionDefinitionCache cache;
    private final PropositionDefinitionRelationForwardVisitor forwardVisitor;
    private final PropositionDefinitionRelationBackwardVisitor backwardVisitor;
    private final Configuration configuration;
    private Neo4jHome home;
    private boolean neo4jStopped;
    private final String keyType;
    private Transaction transaction;
    private int count;
    private final Set<String> missingPropIds;

    Neo4jQueryResultsHandlerWrapped(Query inQuery, DataSource dataSource, Configuration configuration) throws QueryResultsHandlerInitException {
        this.query = inQuery;
        try {
            this.forwardVisitor = new PropositionDefinitionRelationForwardVisitor();
            this.backwardVisitor = new PropositionDefinitionRelationBackwardVisitor();
        }
        catch (KnowledgeSourceReadException ex) {
            throw new QueryResultsHandlerInitException((Throwable)ex);
        }
        this.configuration = configuration;
        try {
            this.keyType = dataSource.getKeyType();
        }
        catch (DataSourceReadException ex) {
            throw new QueryResultsHandlerInitException((Throwable)ex);
        }
        this.missingPropIds = new HashSet<String>();
    }

    public void start(PropositionDefinitionCache cache) throws QueryResultsHandlerProcessingException {
        this.cache = cache;
        try {
            this.home = new Neo4jHome(this.configuration.getNeo4jHome());
            this.home.stopServer();
            this.neo4jStopped = true;
            File dbPath = this.home.getDbPath();
            LOGGER.info("Database path is {}", (Object)dbPath);
            GraphDatabaseFactory factory = new GraphDatabaseFactory();
            GraphDatabaseBuilder dbBuilder = factory.newEmbeddedDatabaseBuilder(dbPath.getAbsolutePath());
            if (this.query.getQueryMode() == QueryMode.REPLACE) {
                this.deleteAll();
            }
            this.db = dbBuilder.newGraphDatabase();
        }
        catch (CommandFailedException | IOException | InterruptedException ex) {
            throw new QueryResultsHandlerProcessingException((Throwable)ex);
        }
        this.transaction = this.db.beginTx();
    }

    public void handleQueryResult(String keyId, List<Proposition> propositions, Map<Proposition, Set<Proposition>> forwardDerivations, Map<Proposition, Set<Proposition>> backwardDerivations, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        this.nodes.clear();
        if (++this.count % 2000 == 0) {
            if (this.transaction != null) {
                this.transaction.success();
                this.transaction.close();
                this.transaction = null;
            }
            this.transaction = this.db.beginTx();
        }
        try {
            this.handleReferences(propositions, references);
            this.handleDerivations(forwardDerivations, true);
            this.handleDerivations(backwardDerivations, false);
        }
        catch (QueryResultsHandlerProcessingException ex) {
            throw ex;
        }
        catch (ProtempaException ex) {
            throw new QueryResultsHandlerProcessingException((Throwable)ex);
        }
    }

    public void finish() throws QueryResultsHandlerProcessingException {
        if (this.db != null) {
            Schema schema;
            this.transaction.success();
            this.transaction.close();
            this.transaction = null;
            try (Transaction tx = this.db.beginTx();){
                if (this.query.getQueryMode() == QueryMode.REPLACE) {
                    schema = this.db.schema();
                    schema.indexFor(NODE_LABEL).on("__uid").create();
                    schema.indexFor(NODE_LABEL).on("__type").create();
                    for (IndexOnProperty indexOnProperty : this.configuration.getPropertiesToIndex()) {
                        schema.indexFor(NODE_LABEL).on(indexOnProperty.getPropertyName()).create();
                    }
                }
                tx.success();
            }
            if (this.query.getQueryMode() == QueryMode.REPLACE) {
                tx = this.db.beginTx();
                var2_2 = null;
                try {
                    schema = this.db.schema();
                    schema.awaitIndexesOnline(4L, TimeUnit.HOURS);
                    tx.success();
                }
                catch (Throwable schema2) {
                    var2_2 = schema2;
                    throw schema2;
                }
                finally {
                    if (tx != null) {
                        if (var2_2 != null) {
                            try {
                                tx.close();
                            }
                            catch (Throwable schema2) {
                                var2_2.addSuppressed(schema2);
                            }
                        } else {
                            tx.close();
                        }
                    }
                }
            }
            tx = this.db.beginTx();
            var2_2 = null;
            try {
                Node node;
                try {
                    node = this.db.findNode(Neo4jStatistics.NODE_LABEL, null, null);
                }
                catch (MultipleFoundException ex) {
                    throw new QueryResultsHandlerProcessingException("duplicate statistics node", (Throwable)ex);
                }
                if (node == null) {
                    node = this.db.createNode(new Label[]{Neo4jStatistics.NODE_LABEL});
                }
                ResourceIterator findNodes = this.db.findNodes(NODE_LABEL, this.keyType, null);
                int countKeys = IteratorUtil.count((Iterator)findNodes);
                node.setProperty("numKeys", (Object)countKeys);
                tx.success();
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (tx != null) {
                    if (var2_2 != null) {
                        try {
                            tx.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        tx.close();
                    }
                }
            }
        }
    }

    public void validate() throws QueryResultsHandlerValidationFailedException {
    }

    public void close() throws QueryResultsHandlerCloseException {
        if (this.db != null) {
            if (this.transaction != null) {
                this.transaction.close();
            }
            this.db.shutdown();
        }
        if (this.neo4jStopped) {
            try {
                this.home.startServer();
            }
            catch (CommandFailedException | IOException | InterruptedException ex) {
                throw new QueryResultsHandlerCloseException((Throwable)ex);
            }
        }
    }

    public void cancel() {
    }

    private Node node(Proposition inProposition) throws QueryResultsHandlerProcessingException {
        String uid = inProposition.getUniqueId().getStringRepresentation();
        MapPropositionVisitor visitor = new MapPropositionVisitor(this.configuration, this.cache);
        Node node = null;
        if (this.query.getQueryMode() == QueryMode.REPLACE) {
            node = this.db.createNode(new Label[]{NODE_LABEL});
        } else {
            try {
                node = this.db.findNode(NODE_LABEL, "__uid", (Object)uid);
            }
            catch (MultipleFoundException ex) {
                throw new QueryResultsHandlerProcessingException("duplicate uid " + uid, (Throwable)ex);
            }
            if (node == null) {
                node = this.db.createNode(new Label[]{NODE_LABEL});
            }
        }
        assert (node != null) : "node was never set";
        String propId = inProposition.getId();
        PropositionDefinition pd = this.cache.get(propId);
        if (pd == null && this.missingPropIds.add(propId)) {
            LOGGER.warn("No proposition definition with id {}", (Object)propId);
        }
        node.setProperty("displayName", (Object)(pd != null ? pd.getDisplayName() : propId));
        node.setProperty("__type", (Object)inProposition.getId());
        inProposition.accept((PropositionVisitor)visitor);
        for (Map.Entry<String, Object> entry : visitor.getMap().entrySet()) {
            Object value = entry.getValue();
            try {
                if (value != null) {
                    node.setProperty(entry.getKey(), value);
                    continue;
                }
                node.setProperty(entry.getKey(), this.configuration.getNullValue());
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        node.setProperty("__uid", (Object)uid);
        return node;
    }

    private Node getOrCreateNode(Proposition inProposition) throws QueryResultsHandlerProcessingException {
        if (!this.nodes.containsKey(inProposition.getUniqueId())) {
            this.nodes.put(inProposition.getUniqueId(), this.node(inProposition));
        }
        return this.nodes.get(inProposition.getUniqueId());
    }

    private void relate(Node source, Node target, RelationshipType type) {
        if (!this.hasRelationshipBetween(type, source, target)) {
            Relationship relationship = source.createRelationshipTo(target, type);
            relationship.setProperty("name", (Object)relationship.getType().name());
        }
    }

    private RelationshipType getOrCreateRelation(String name) {
        if (!this.relations.containsKey(name)) {
            DynamicRelationshipType relationshipType = DynamicRelationshipType.withName((String)name);
            this.relations.put(name, (RelationshipType)relationshipType);
        }
        return this.relations.get(name);
    }

    private boolean hasRelationshipBetween(RelationshipType type, Node source, Node target) {
        return this.getRelationshipBetween(type, source, target) != null;
    }

    private Relationship getRelationshipBetween(RelationshipType type, Node source, Node target) {
        for (Relationship rel : source.getRelationships()) {
            if (!rel.getType().equals(type) || !rel.getOtherNode(source).equals(target)) continue;
            return rel;
        }
        return null;
    }

    private void handleDerivations(Map<Proposition, Set<Proposition>> derivations, boolean forward) throws QueryResultsHandlerProcessingException, ProtempaException {
        for (Map.Entry<Proposition, Set<Proposition>> entry : derivations.entrySet()) {
            Proposition sourceProposition = entry.getKey();
            Node source = this.getOrCreateNode(sourceProposition);
            for (Proposition targetProposition : entry.getValue()) {
                Node target = this.getOrCreateNode(targetProposition);
                String derivationType = this.derivationType(sourceProposition, targetProposition, forward);
                RelationshipType relation = this.getOrCreateRelation(derivationType);
                this.relate(source, target, relation);
            }
        }
    }

    private void handleReferences(List<Proposition> propositions, Map<UniqueId, Proposition> references) throws QueryResultsHandlerProcessingException {
        for (Proposition proposition : propositions) {
            String[] names;
            Node source = this.getOrCreateNode(proposition);
            for (String name : names = proposition.getReferenceNames()) {
                List ids = proposition.getReferences(name);
                RelationshipType relation = this.getOrCreateRelation(name);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Processing {} references with type {} for {}", new Object[]{ids.size(), name, proposition.getId()});
                }
                for (UniqueId id : ids) {
                    Proposition targetProposition = references.get(id);
                    if (targetProposition != null) {
                        Node target = this.getOrCreateNode(targetProposition);
                        this.relate(source, target, relation);
                        continue;
                    }
                    LOGGER.error("No proposition for {}", (Object)id);
                    throw new QueryResultsHandlerProcessingException("No proposition for id " + id);
                }
            }
        }
    }

    private String derivationType(Proposition source, Proposition target, boolean forward) throws ProtempaException {
        Derivations.Type result;
        String key = source.getId() + "->" + target.getId();
        String inverseKey = target.getId() + "->" + source.getId();
        PropositionDefinition definition = this.cache.get(source.getId());
        if (this.deriveType.containsKey(key)) {
            result = this.deriveType.get(key);
        } else if (this.deriveType.containsKey(inverseKey)) {
            result = Derivations.inverse(this.deriveType.get(inverseKey));
        } else {
            PropositionDefinitionRelationVisitor visitor = forward ? this.forwardVisitor : this.backwardVisitor;
            visitor.setTarget(this.cache.get(target.getId()));
            definition.acceptChecked((PropositionDefinitionCheckedVisitor)visitor);
            result = visitor.getRelation();
            this.deriveType.put(key, result);
            this.deriveType.put(inverseKey, Derivations.inverse(result));
        }
        return result.name();
    }

    private void deleteAll() throws IOException {
        LOGGER.info("Deleting all data from {}", (Object)this.home.getDbPath());
        GraphDatabaseFactory factory = new GraphDatabaseFactory();
        GraphDatabaseService newEmbeddedDatabase = factory.newEmbeddedDatabase(this.home.getDbPath().getAbsolutePath());
        newEmbeddedDatabase.shutdown();
        FileUtils.deleteDirectory((File)this.home.getDbPath());
        LOGGER.info("Done deleting all data from {}", (Object)this.home.getDbPath());
    }
}

