/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.cci.aiw.neo4jetl;

import org.protempa.proposition.value.BooleanValue;
import org.protempa.proposition.value.DateValue;
import org.protempa.proposition.value.InequalityNumberValue;
import org.protempa.proposition.value.NominalValue;
import org.protempa.proposition.value.NumberValue;
import org.protempa.proposition.value.OrdinalValue;
import org.protempa.proposition.value.Value;
import org.protempa.proposition.value.ValueList;
import org.protempa.proposition.value.ValueVisitor;

public class RawValueVisitor
implements ValueVisitor {
    Object value;

    public void visit(NominalValue nominalValue) {
        Object result;
        String v = nominalValue.getFormatted();
        try {
            result = Long.parseLong(v);
        }
        catch (NumberFormatException e) {
            result = v;
        }
        this.value = result;
    }

    public void visit(OrdinalValue ordinalValue) {
        this.value = ordinalValue.getValue();
    }

    public void visit(BooleanValue booleanValue) {
        this.value = booleanValue.booleanValue();
    }

    public void visit(ValueList<? extends Value> listValue) {
        throw new UnsupportedOperationException("Not supported yet!");
    }

    public void visit(NumberValue numberValue) {
        this.value = numberValue.doubleValue();
    }

    public void visit(InequalityNumberValue inequalityNumberValue) {
        this.value = inequalityNumberValue.doubleValue();
    }

    public void visit(DateValue dateValue) {
        this.value = dateValue.getDate().getTime();
    }

    public Object getValue() {
        return this.value;
    }
}

