/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.datatype.LiquibaseDataType;
import liquibase.datatype.core.BigIntType;
import liquibase.datatype.core.BlobType;
import liquibase.datatype.core.BooleanType;
import liquibase.datatype.core.CharType;
import liquibase.datatype.core.ClobType;
import liquibase.datatype.core.DateTimeType;
import liquibase.datatype.core.DateType;
import liquibase.datatype.core.DecimalType;
import liquibase.datatype.core.DoubleType;
import liquibase.datatype.core.FloatType;
import liquibase.datatype.core.IntType;
import liquibase.datatype.core.NCharType;
import liquibase.datatype.core.NVarcharType;
import liquibase.datatype.core.NumberType;
import liquibase.datatype.core.SmallIntType;
import liquibase.datatype.core.TimeType;
import liquibase.datatype.core.TimestampType;
import liquibase.datatype.core.TinyIntType;
import liquibase.datatype.core.VarcharType;
import liquibase.logging.LogFactory;
import liquibase.statement.DatabaseFunction;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;

public class SqlUtil {
    public static boolean isNumeric(int dataType) {
        List<Integer> numericTypes = Arrays.asList(-5, -7, 4, 5, -6, 3, 8, 6, 2, 7);
        return numericTypes.contains(dataType);
    }

    public static boolean isBoolean(int dataType) {
        return dataType == 16;
    }

    public static boolean isDate(int dataType) {
        List<Integer> validTypes = Arrays.asList(91, 92, 93);
        return validTypes.contains(dataType);
    }

    public static Object parseValue(Database database, Object val, DataType type) {
        if (!(val instanceof String)) {
            return val;
        }
        int typeId = Integer.MIN_VALUE;
        if (type.getDataTypeId() != null) {
            typeId = type.getDataTypeId();
        }
        String typeName = type.getTypeName();
        LiquibaseDataType liquibaseDataType = DataTypeFactory.getInstance().from(type, database);
        String stringVal = (String)val;
        if (stringVal.isEmpty()) {
            if (liquibaseDataType instanceof CharType) {
                return "";
            }
            return null;
        }
        if (database instanceof OracleDatabase && !stringVal.startsWith("'") && !stringVal.endsWith("'")) {
            Object maybeDate = null;
            if (liquibaseDataType instanceof DateType || typeId == 91) {
                maybeDate = stringVal.endsWith("'HH24:MI:SS')") ? DataTypeFactory.getInstance().fromDescription("time", database).sqlToObject(stringVal, database) : DataTypeFactory.getInstance().fromDescription("date", database).sqlToObject(stringVal, database);
            } else if (liquibaseDataType instanceof DateTimeType || typeId == 93) {
                maybeDate = DataTypeFactory.getInstance().fromDescription("datetime", database).sqlToObject(stringVal, database);
            } else if (!stringVal.matches("\\d+\\.?\\d*")) {
                return new DatabaseFunction(stringVal);
            }
            if (maybeDate != null) {
                if (maybeDate instanceof Date) {
                    return maybeDate;
                }
                return new DatabaseFunction(stringVal);
            }
        }
        if (stringVal.startsWith("'") && stringVal.endsWith("'")) {
            stringVal = stringVal.substring(1, stringVal.length() - 1);
        } else if (stringVal.startsWith("((") && stringVal.endsWith("))")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("('") && stringVal.endsWith("')")) {
            stringVal = stringVal.substring(2, stringVal.length() - 2);
        } else if (stringVal.startsWith("(") && stringVal.endsWith(")")) {
            return new DatabaseFunction(stringVal.substring(1, stringVal.length() - 1));
        }
        Scanner scanner = new Scanner(stringVal.trim());
        if (typeId == 2003) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof BigIntType || typeId == -5) {
            if (scanner.hasNextBigInteger()) {
                return scanner.nextBigInteger();
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == -2) {
            return new DatabaseFunction(stringVal.trim());
        }
        if (typeId == -7) {
            if (stringVal.startsWith("b'")) {
                stringVal = stringVal.replaceFirst("b'", "").replaceFirst("'$", "");
            }
            stringVal = stringVal.trim();
            if (scanner.hasNextBoolean()) {
                return scanner.nextBoolean();
            }
            return new Integer(stringVal);
        }
        if (liquibaseDataType instanceof BlobType || typeId == 2004) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof BooleanType || typeId == 16) {
            if (scanner.hasNextBoolean()) {
                return scanner.nextBoolean();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof CharType || typeId == 1) {
            return stringVal;
        }
        if (liquibaseDataType instanceof ClobType || typeId == 2005) {
            return stringVal;
        }
        if (typeId == 70) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof DateType || typeId == 91) {
            if (typeName.equalsIgnoreCase("year")) {
                return stringVal.trim();
            }
            return DataTypeFactory.getInstance().fromDescription("date", database).sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof DecimalType || typeId == 3) {
            if (scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == 2001) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof DoubleType || typeId == 8) {
            if (scanner.hasNextDouble()) {
                return scanner.nextDouble();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof FloatType || typeId == 6) {
            if (scanner.hasNextFloat()) {
                return Float.valueOf(scanner.nextFloat());
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof IntType || typeId == 4) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == 2000) {
            return new DatabaseFunction(stringVal);
        }
        if (typeId == -16) {
            return stringVal;
        }
        if (typeId == -4) {
            return new DatabaseFunction(stringVal);
        }
        if (typeId == -1) {
            return stringVal;
        }
        if (liquibaseDataType instanceof NCharType || typeId == -15 || liquibaseDataType.getName().equalsIgnoreCase("NCLOB")) {
            return stringVal;
        }
        if (typeId == 2011) {
            return stringVal;
        }
        if (typeId == 0) {
            return null;
        }
        if (liquibaseDataType instanceof NumberType || typeId == 2) {
            if (scanner.hasNextBigDecimal()) {
                return scanner.nextBigDecimal();
            }
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof NVarcharType || typeId == -9) {
            return stringVal;
        }
        if (typeId == 1111) {
            if (database instanceof DB2Database && typeName.equalsIgnoreCase("DECFLOAT")) {
                return new BigDecimal(stringVal);
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == 7) {
            return new BigDecimal(stringVal.trim());
        }
        if (typeId == 2006) {
            return new DatabaseFunction(stringVal);
        }
        if (typeId == -8) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof SmallIntType || typeId == 5) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == 2009) {
            return new DatabaseFunction(stringVal);
        }
        if (typeId == 2002) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof TimeType || typeId == 92) {
            return DataTypeFactory.getInstance().fromDescription("time", database).sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof DateTimeType || liquibaseDataType instanceof TimestampType || typeId == 93) {
            return DataTypeFactory.getInstance().fromDescription("datetime", database).sqlToObject(stringVal, database);
        }
        if (liquibaseDataType instanceof TinyIntType || typeId == -6) {
            if (scanner.hasNextInt()) {
                return scanner.nextInt();
            }
            return new DatabaseFunction(stringVal);
        }
        if (typeId == -3) {
            return new DatabaseFunction(stringVal);
        }
        if (liquibaseDataType instanceof VarcharType || typeId == 12) {
            return stringVal;
        }
        if (database instanceof MySQLDatabase && typeName.toLowerCase().startsWith("enum")) {
            return stringVal;
        }
        LogFactory.getLogger().info("Unknown default value: value '" + stringVal + "' type " + typeName + " (" + type + "), assuming it is a function");
        return new DatabaseFunction(stringVal);
    }

    public static String replacePredicatePlaceholders(Database database, String predicate, List<String> columnNames, List<Object> parameters) {
        Matcher matcher = Pattern.compile(":name|\\?|:value").matcher(predicate.trim());
        StringBuffer sb = new StringBuffer();
        Iterator<String> columnNameIter = columnNames.iterator();
        Iterator<Object> paramIter = parameters.iterator();
        block0: while (matcher.find()) {
            if (matcher.group().equals(":name")) {
                while (columnNameIter.hasNext()) {
                    String columnName = columnNameIter.next();
                    if (columnName == null) continue;
                    matcher.appendReplacement(sb, Matcher.quoteReplacement(database.escapeObjectName(columnName, Column.class)));
                    continue block0;
                }
                continue;
            }
            if (!paramIter.hasNext()) continue;
            Object param = paramIter.next();
            matcher.appendReplacement(sb, Matcher.quoteReplacement(DataTypeFactory.getInstance().fromObject(param, database).objectToSql(param, database)));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

