/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.Datum;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.ROWID;

abstract class PABAccessor
extends Accessor {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Mar_12_20:10:49_PDT_2013";
    public static final boolean TRACE = false;

    PABAccessor() {
    }

    @Override
    void setOffsets(int n2) {
        this.columnIndex = this.statement.defineByteSubRange;
        this.statement.defineByteSubRange = this.columnIndex + n2 * this.byteLength;
    }

    @Override
    void init(OracleStatement oracleStatement, int n2, int n3, short s2, boolean bl) throws SQLException {
        this.statement = oracleStatement;
        this.outBind = bl;
        this.internalType = n2;
        this.defineType = n3;
        this.formOfUse = s2;
    }

    @Override
    abstract void initForDataAccess(int var1, int var2, String var3) throws SQLException;

    @Override
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2) throws SQLException {
        this.describeType = n2;
        this.describeMaxLength = n3;
        this.nullable = bl;
        this.precision = n5;
        this.scale = n6;
        this.flags = n4;
        this.contflag = n7;
        this.total_elems = n8;
        this.formOfUse = s2;
    }

    @Override
    void initForDescribe(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, String string) throws SQLException {
        this.describeTypeName = string;
        this.describeOtype = null;
        this.initForDescribe(n2, n3, bl, n4, n5, n6, n7, n8, s2);
    }

    @Override
    OracleInputStream initForNewRow() throws SQLException {
        this.unimpl("initForNewRow");
        return null;
    }

    @Override
    int useForDataAccessIfPossible(int n2, int n3, int n4, String string) throws SQLException {
        int n5 = 3;
        int n6 = 0;
        int n7 = 0;
        if (this.internalType != 0) {
            if (this.internalType != n2) {
                n5 = 0;
            } else if (this.rowSpaceIndicator != null) {
                n6 = this.byteLength;
                n7 = this.charLength;
            }
        }
        if (n5 == 3) {
            this.initForDataAccess(n3, n4, string);
            if (!this.outBind && n6 >= this.byteLength && n7 >= this.charLength) {
                n5 = 2;
            }
        }
        return n5;
    }

    @Override
    boolean useForDescribeIfPossible(int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, short s2, String string) throws SQLException {
        if (this.externalType == 0 && n2 != this.describeType) {
            return false;
        }
        this.initForDescribe(n2, n3, bl, n4, n5, n6, n7, n8, s2, string);
        return true;
    }

    @Override
    void setFormOfUse(short s2) {
        this.formOfUse = s2;
    }

    @Override
    void updateColumnNumber(int n2) {
    }

    @Override
    public String toString() {
        return super.toString() + ", statement=" + this.statement + ", outBind=" + this.outBind + ", internalType=" + this.internalType + ", internalTypeMaxLength=" + this.internalTypeMaxLength + ", isStream=" + this.isStream + ", formOfUse=" + this.formOfUse + ", internalOtype=" + this.internalOtype + ", externalType=" + this.externalType + ", internalTypeName=" + this.internalTypeName + ", columnName=" + this.columnName + ", describeType=" + this.describeType + ", describeMaxLength=" + this.describeMaxLength + ", nullable=" + this.nullable + ", precision=" + this.precision + ", scale=" + this.scale + ", flags=" + this.flags + ", contflag=" + this.contflag + ", total_elems=" + this.total_elems + ", describeOtype=" + this.describeOtype + ", describeTypeName=" + this.describeTypeName + ", rowSpaceByte=" + this.rowSpaceByte + ", rowSpaceChar=" + this.rowSpaceChar + ", rowSpaceIndicator=" + this.rowSpaceIndicator + ", columnIndex=" + this.columnIndex + ", lengthIndex=" + this.lengthIndex + ", indicatorIndex=" + this.indicatorIndex + ", byteLength=" + this.byteLength + ", charLength=" + this.charLength;
    }

    @Override
    OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        if (this.rowSpaceMetaData == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        byte by = this.rowSpaceMetaData[this.metaDataIndex + 1 * n2];
        if ((by & 1) != 0) {
            return OracleResultSet.AuthorizationIndicator.UNAUTHORIZED;
        }
        if (this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED || this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.NONE) {
            return OracleResultSet.AuthorizationIndicator.NONE;
        }
        return OracleResultSet.AuthorizationIndicator.UNKNOWN;
    }

    @Override
    byte[] privateGetBytes(int n2) throws SQLException {
        return this.getBytes(n2);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] != -1) {
            short s2 = this.rowSpaceIndicator[this.lengthIndex + n2];
            int n3 = this.columnIndex + this.byteLength * n2;
            byArray = new byte[s2];
            System.arraycopy(this.rowSpaceByte, n3, byArray, 0, s2);
        }
        return byArray;
    }

    @Override
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        this.unimpl("getOraclePlsqlIndexTable");
        return null;
    }

    @Override
    ResultSet getCursor(int n2) throws SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    ROWID getROWID(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n2] == -1) {
            return null;
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return customDatumFactory.create(datum, 0);
    }

    @Override
    Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        Object object = datum.toJdbc();
        return oracleDataFactory.create(object, 0);
    }

    @Override
    ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        Datum datum = this.getOracleObject(n2);
        return oRADataFactory.create(datum, 0);
    }

    @Override
    boolean isNull(int n2) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return this.rowSpaceIndicator[this.indicatorIndex + n2] == -1;
    }

    @Override
    void setNull(int n2, boolean bl) throws SQLException {
        if (this.rowSpaceIndicator == null) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.rowSpaceIndicator[this.indicatorIndex + n2] = (short)(bl ? -1 : 0);
    }

    @Override
    void fetchNextColumns() throws SQLException {
    }

    @Override
    void calculateSizeTmpByteArray() {
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    void copyRow() throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    int readStream(byte[] byArray, int n2) throws SQLException, IOException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 148);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    void initMetadata() throws SQLException {
    }

    @Override
    void setDisplaySize(int n2) throws SQLException {
        this.describeMaxLength = n2;
    }

    @Override
    void saveDataFromOldDefineBuffers(byte[] byArray, char[] cArray, short[] sArray, int n2, int n3) throws SQLException {
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.statement.getConnectionDuringExceptionHandling();
    }
}

