/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.tomcat.v7;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.SessionEvent;
import org.apache.catalina.SessionListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.session.SingleSignOutHandler;

public class SingleSignOutValve
extends ValveBase
implements SessionListener {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final SingleSignOutHandler handler = new SingleSignOutHandler();

    public void setArtifactParameterName(String name) {
        this.handler.setArtifactParameterName(name);
    }

    public void setLogoutParameterName(String name) {
        this.handler.setLogoutParameterName(name);
    }

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.handler.setSessionMappingStorage(storage);
    }

    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (this.handler.isTokenRequest((HttpServletRequest)request)) {
            this.handler.recordSession((HttpServletRequest)request);
            request.getSessionInternal(true).addSessionListener((SessionListener)this);
        } else {
            if (this.handler.isLogoutRequest((HttpServletRequest)request)) {
                this.handler.destroySession((HttpServletRequest)request);
                return;
            }
            this.log.debug((Object)("Ignoring URI " + request.getRequestURI()));
        }
        this.getNext().invoke(request, response);
    }

    public void sessionEvent(SessionEvent event) {
        if ("destroySession".equals(event.getType())) {
            this.log.debug((Object)"Cleaning up SessionMappingStorage on destroySession event");
            this.handler.getSessionMappingStorage().removeBySessionById(event.getSession().getId());
        }
    }

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.log.info((Object)"Starting...");
        this.handler.init();
        this.log.info((Object)"Startup completed.");
    }
}

