/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.standardapis.dao;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.NonUniqueResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DatabaseSupport {
    private static Logger LOGGER = LoggerFactory.getLogger(DatabaseSupport.class);
    private final EntityManager entityManager;

    public DatabaseSupport(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public <T> List<T> getAll(Class<T> entity) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entity);
        criteriaQuery.from(entity);
        TypedQuery typedQuery = this.entityManager.createQuery(criteriaQuery);
        List jobs = typedQuery.getResultList();
        return jobs;
    }

    public <T, Y> T getUniqueByAttribute(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        TypedQuery<T> query = this.createTypedQuery(entityCls, attribute, value);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            LOGGER.warn("Result not unique for {} = {}", attribute, value);
        }
        catch (NoResultException nre) {
            LOGGER.debug("Result not existant for {} = {}", attribute, value);
        }
        return (T)result;
    }

    public <T, Y> T getUniqueByAttribute(Class<T> entityCls, String attributeName, Y value) {
        TypedQuery<T> query = this.createTypedQuery(entityCls, attributeName, value);
        Object result = null;
        try {
            result = query.getSingleResult();
        }
        catch (NonUniqueResultException nure) {
            LOGGER.warn("Result not unique for {} = {}", (Object)attributeName, value);
        }
        catch (NoResultException nre) {
            LOGGER.debug("Result not existant for {} = {}", (Object)attributeName, value);
        }
        return (T)result;
    }

    public <T, Y> List<T> getListByAttribute(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        TypedQuery<T> query = this.createTypedQuery(entityCls, attribute, value);
        return query.getResultList();
    }

    private <T, Y> TypedQuery<T> createTypedQuery(Class<T> entityCls, SingularAttribute<T, Y> attribute, Y value) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attribute);
        return this.entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)path, value)));
    }

    private <T, Y> TypedQuery<T> createTypedQuery(Class<T> entityCls, String attributeName, Y value) {
        CriteriaBuilder builder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(entityCls);
        Root root = criteriaQuery.from(entityCls);
        Path path = root.get(attributeName);
        return this.entityManager.createQuery(criteriaQuery.where((Expression)builder.equal((Expression)path, value)));
    }
}

