/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.config;

import com.google.inject.Singleton;
import org.eurekaclinical.standardapis.props.CasJerseyEurekaClinicalProperties;

@Singleton
public class UserServiceProperties
extends CasJerseyEurekaClinicalProperties {
    public UserServiceProperties() {
        super("/etc/ec-user");
    }

    public String getProxyCallbackServer() {
        return this.getValue("eurekaclinical.userservice.callbackserver");
    }

    public String getVerificationUrl() {
        String verUrl = this.getUserWebappUrl();
        return verUrl + (verUrl.endsWith("/") ? "" : "/") + "verify?code=";
    }

    public String getVerificationEmailSubject() {
        return this.getValue("eurekaclinical.userservice.email.verify.subject");
    }

    public String getActivationEmailSubject() {
        return this.getValue("eurekaclinical.userservice.email.activation.subject");
    }

    public String getPasswordChangeEmailSubject() {
        return this.getValue("eurekaclinical.userservice.email.password.subject");
    }

    public String getPasswordResetEmailSubject() {
        return this.getValue("eurekaclinical.userservice.email.reset.subject");
    }

    public String getFromEmailAddress() {
        return this.getValue("eurekaclinical.userservice.email.from");
    }

    public String getUrl() {
        return this.getValue("eurekaclinical.userservice.url");
    }

    public String getUserWebappUrl() {
        return this.getValue("eurekaclinical.userwebapp.url");
    }

    public int getRegistrationTimeout() {
        return this.getIntValue("eurekaclinical.userservice.registration.timeout", 72);
    }

    public boolean isOAuthRegistrationEnabled() {
        return this.isGoogleOAuthRegistrationEnabled() || this.isGitHubOAuthRegistrationEnabled() || this.isGlobusOAuthRegistrationEnabled();
    }

    public boolean isGoogleOAuthRegistrationEnabled() {
        return this.getGoogleOAuthKey() != null && this.getGoogleOAuthSecret() != null;
    }

    public boolean isGitHubOAuthRegistrationEnabled() {
        return this.getGitHubOAuthKey() != null && this.getGitHubOAuthSecret() != null;
    }

    public boolean isGlobusOAuthRegistrationEnabled() {
        return this.getGlobusOAuthKey() != null && this.getGlobusOAuthSecret() != null;
    }

    public boolean isLocalAccountRegistrationEnabled() {
        return Boolean.parseBoolean(this.getValue("eurekaclinical.userwebapp.localregistrationenabled"));
    }

    public boolean isRegistrationEnabled() {
        return this.isLocalAccountRegistrationEnabled() || this.isOAuthRegistrationEnabled();
    }

    public String getGitHubCallbackUrl() {
        return this.getValue("eurekaclinical.userservice.githuboauthcallbackurl");
    }

    public String getGitHubOAuthKey() {
        return this.getValue("eurekaclinical.userservice.githuboauthkey");
    }

    public String getGitHubOAuthSecret() {
        return this.getValue("eurekaclinical.userservice.githuboauthsecret");
    }

    public String getGlobusCallbackUrl() {
        return this.getValue("eurekaclinical.userservice.globusoauthcallbackurl");
    }

    public String getGlobusOAuthKey() {
        return this.getValue("eurekaclinical.userservice.globusoauthkey");
    }

    public String getGlobusOAuthSecret() {
        return this.getValue("eurekaclinical.userservice.globusoauthsecret");
    }

    public String getGoogleCallbackUrl() {
        return this.getValue("eurekaclinical.userservice.googleoauthcallbackurl");
    }

    public String getGoogleOAuthKey() {
        return this.getValue("eurekaclinical.userservice.googleoauthkey");
    }

    public String getGoogleOAuthSecret() {
        return this.getValue("eurekaclinical.userservice.googleoauthsecret");
    }
}

