/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.dao;

import com.google.inject.Inject;
import com.google.inject.Provider;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.eurekaclinical.standardapis.dao.GenericDao;
import org.eurekaclinical.user.service.dao.LocalUserDao;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.LocalUserEntity_;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntity_;

public class JpaLocalUserDao
extends GenericDao<LocalUserEntity, Long>
implements LocalUserDao {
    @Inject
    public JpaLocalUserDao(Provider<EntityManager> inEMProvider) {
        super(LocalUserEntity.class, inEMProvider);
    }

    public LocalUserEntity getByName(String name) {
        CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery criteriaQuery = builder.createQuery(LocalUserEntity.class);
        Root root = criteriaQuery.from(LocalUserEntity.class);
        Subquery subquery = criteriaQuery.subquery(UserEntity.class);
        Root userEntity = subquery.from(UserEntity.class);
        Path username = userEntity.get(UserEntity_.username);
        subquery.select((Expression)userEntity);
        subquery = subquery.where((Expression)builder.equal((Expression)username, (Object)name));
        TypedQuery query = this.getEntityManager().createQuery(criteriaQuery.where((Expression)builder.equal((Expression)root, (Expression)subquery)));
        return (LocalUserEntity)query.getSingleResult();
    }

    public LocalUserEntity getByVerificationCode(String inCode) {
        return (LocalUserEntity)this.getUniqueByAttribute(LocalUserEntity_.verificationCode, (Object)inCode);
    }
}

