/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.email;

import com.google.inject.Inject;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang3.StringUtils;
import org.eurekaclinical.user.service.config.UserServiceProperties;
import org.eurekaclinical.user.service.email.EmailException;
import org.eurekaclinical.user.service.email.EmailSender;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarkerEmailSender
implements EmailSender {
    private static final Logger LOGGER = LoggerFactory.getLogger(FreeMarkerEmailSender.class);
    private final Configuration configuration;
    private final Session session;
    private final UserServiceProperties userServiceProperties;

    @Inject
    public FreeMarkerEmailSender(UserServiceProperties inUserServiceProperties, Session inSession) {
        this.userServiceProperties = inUserServiceProperties;
        this.session = inSession;
        this.configuration = new Configuration();
        this.configuration.setClassForTemplateLoading(this.getClass(), "/templates/");
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
    }

    public void sendVerificationMessage(UserEntity inUser) throws EmailException {
        HashMap<String, String> params = new HashMap<String, String>();
        String verificationUrl = this.userServiceProperties.getVerificationUrl();
        params.put("verificationUrl", verificationUrl);
        this.sendMessage(inUser, "verification.ftl", this.userServiceProperties.getVerificationEmailSubject(), params);
    }

    public void sendActivationMessage(UserEntity inUser) throws EmailException {
        HashMap<String, String> params = new HashMap<String, String>();
        String applicationUrl = this.userServiceProperties.getUserWebappUrl();
        params.put("applicationUrl", applicationUrl);
        this.sendMessage(inUser, "activation.ftl", this.userServiceProperties.getActivationEmailSubject(), params);
    }

    public void sendPasswordChangeMessage(UserEntity inUser) throws EmailException {
        this.sendMessage(inUser, "password.ftl", this.userServiceProperties.getPasswordChangeEmailSubject());
    }

    public void sendPasswordResetMessage(UserEntity inUser, String inNewPassword) throws EmailException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("plainTextPassword", inNewPassword);
        this.sendMessage(inUser, "password_reset.ftl", this.userServiceProperties.getPasswordResetEmailSubject(), params);
    }

    private void sendMessage(UserEntity inUser, String templateName, String subject, Map<String, Object> params) throws EmailException {
        params.put("user", this.extractDisplayName(inUser));
        params.put("config", this.userServiceProperties);
        this.sendMessage(templateName, subject, inUser.getEmail(), params);
    }

    private String extractDisplayName(UserEntity inUser) {
        if (StringUtils.isNotEmpty((CharSequence)inUser.getFullName())) {
            return inUser.getFullName();
        }
        if (StringUtils.isNotEmpty((CharSequence)inUser.getFirstName()) || StringUtils.isNotEmpty((CharSequence)inUser.getLastName())) {
            return inUser.getFirstName() + " " + inUser.getLastName();
        }
        return inUser.getUsername();
    }

    private void sendMessage(UserEntity inUser, String templateName, String subject) throws EmailException {
        HashMap params = new HashMap();
        this.sendMessage(inUser, templateName, subject, params);
    }

    private void sendMessage(String templateName, String subject, String emailAddress, Map<String, Object> params) throws EmailException {
        StringWriter stringWriter = new StringWriter();
        try {
            Template template = this.configuration.getTemplate(templateName);
            template.process(params, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new EmailException(e);
        }
        String content = ((Object)stringWriter).toString();
        MimeMessage message = new MimeMessage(this.session);
        try {
            InternetAddress fromEmailAddress = null;
            String fromEmailAddressStr = this.userServiceProperties.getFromEmailAddress();
            if (fromEmailAddressStr != null) {
                fromEmailAddress = new InternetAddress(fromEmailAddressStr);
            }
            if (fromEmailAddress == null) {
                fromEmailAddress = InternetAddress.getLocalAddress((Session)this.session);
            }
            if (fromEmailAddress == null) {
                try {
                    fromEmailAddress = new InternetAddress("no-reply@" + InetAddress.getLocalHost().getCanonicalHostName());
                }
                catch (UnknownHostException ex) {
                    fromEmailAddress = new InternetAddress("no-reply@localhost");
                }
            }
            message.setFrom((Address)fromEmailAddress);
            message.setSubject(subject);
            message.setContent((Object)content, "text/plain");
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(emailAddress));
            message.setSender((Address)fromEmailAddress);
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            LOGGER.error("Error sending the following email message:");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                message.writeTo((OutputStream)out);
                out.close();
            }
            catch (IOException | MessagingException ex) {
                try {
                    out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            LOGGER.error(out.toString());
            throw new EmailException((Throwable)e);
        }
    }
}

