/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.entity;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.eurekaclinical.user.service.entity.AuthenticationMethodEntity;
import org.eurekaclinical.user.service.entity.LoginTypeEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntityVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity
@Table(name="local_users")
public class LocalUserEntity
extends UserEntity {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalUserEntity.class);
    @Column(nullable=false)
    private String password;
    private String verificationCode;
    private boolean verified;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date passwordExpiration;

    public LocalUserEntity(LoginTypeEntity loginType, AuthenticationMethodEntity authenticationMethod) {
        super(loginType, authenticationMethod);
    }

    protected LocalUserEntity() {
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String inPassword) {
        this.password = inPassword;
    }

    public String getVerificationCode() {
        return this.verificationCode;
    }

    public void setVerificationCode(String inVerificationCode) {
        this.verificationCode = inVerificationCode;
    }

    public Date getPasswordExpiration() {
        return this.passwordExpiration;
    }

    public void setPasswordExpiration(Date inPasswordExpiration) {
        this.passwordExpiration = inPasswordExpiration;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public void setVerified(boolean inVerified) {
        this.verified = inVerified;
    }

    public void accept(UserEntityVisitor userEntityVisitor) {
        userEntityVisitor.visit(this);
    }
}

