/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.eurekaclinical.user.service.entity.AuthenticationMethodEntity;
import org.eurekaclinical.user.service.entity.LoginTypeEntity;
import org.eurekaclinical.user.service.entity.RoleEntity;
import org.eurekaclinical.user.service.entity.UserEntityVisitable;

@Entity
@Table(name="users")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class UserEntity
implements org.eurekaclinical.standardapis.entity.UserEntity<RoleEntity>,
UserEntityVisitable {
    @Id
    @SequenceGenerator(name="USER_SEQ_GENERATOR", sequenceName="USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="USER_SEQ_GENERATOR")
    private Long id;
    private boolean active;
    @Column(unique=true, nullable=false)
    private String username;
    private String firstName;
    private String lastName;
    private String fullName;
    private String title;
    private String department;
    @Column(nullable=false)
    private String email;
    private String organization;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(nullable=false)
    private Date created;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastLogin;
    @ManyToOne(optional=false)
    @JoinColumn(referencedColumnName="id", nullable=false)
    private LoginTypeEntity loginType;
    @ManyToOne(optional=false)
    @JoinColumn(referencedColumnName="id", nullable=false)
    private AuthenticationMethodEntity authenticationMethod;
    @ManyToMany(cascade={CascadeType.REFRESH, CascadeType.MERGE}, targetEntity=RoleEntity.class)
    @JoinTable(name="user_role", joinColumns={@JoinColumn(name="user_id")}, inverseJoinColumns={@JoinColumn(name="role_id")})
    private List<RoleEntity> roles = new ArrayList();

    protected UserEntity() {
        this.created = new Date();
    }

    protected UserEntity(LoginTypeEntity loginType, AuthenticationMethodEntity authenticationMethod) {
        this();
        assert (loginType != null) : "loginType cannot be null";
        assert (authenticationMethod != null) : "authenticationMethod cannot be null";
        this.loginType = loginType;
        this.authenticationMethod = authenticationMethod;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long inId) {
        this.id = inId;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean inActive) {
        this.active = inActive;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created == null ? new Date() : created;
    }

    public void addRole(RoleEntity inRole) {
        this.roles.add(inRole);
    }

    public void removeRole(RoleEntity inRole) {
        this.roles.remove(inRole);
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String inFirstName) {
        this.firstName = inFirstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String inLastName) {
        this.lastName = inLastName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String inEmail) {
        this.email = inEmail;
    }

    public String getOrganization() {
        return this.organization;
    }

    public void setOrganization(String inOrganization) {
        this.organization = inOrganization;
    }

    public Date getLastLogin() {
        return this.lastLogin;
    }

    public void setLastLogin(Date inLastLogin) {
        this.lastLogin = inLastLogin;
    }

    public List<RoleEntity> getRoles() {
        return this.roles;
    }

    public void setRoles(List<RoleEntity> inRoles) {
        this.roles = inRoles;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String inTitle) {
        this.title = inTitle;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String inDepartment) {
        this.department = inDepartment;
    }

    public LoginTypeEntity getLoginType() {
        return this.loginType;
    }

    void setLoginType(LoginTypeEntity loginType) {
        this.loginType = loginType;
    }

    public AuthenticationMethodEntity getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    void setAuthenticationMethod(AuthenticationMethodEntity authMethod) {
        this.authenticationMethod = authMethod;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

