/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.entity;

import org.eurekaclinical.user.client.comm.authentication.AuthenticationMethod;
import org.eurekaclinical.user.client.comm.authentication.LoginType;
import org.eurekaclinical.user.service.dao.AuthenticationMethodDao;
import org.eurekaclinical.user.service.dao.LoginTypeDao;
import org.eurekaclinical.user.service.entity.AuthenticationMethodEntity;
import org.eurekaclinical.user.service.entity.LdapUserEntity;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.LoginTypeEntity;
import org.eurekaclinical.user.service.entity.OAuthUserEntity;

public final class UserEntityFactory {
    private final LoginTypeDao loginTypeDao;
    private final AuthenticationMethodDao authenticationMethodDao;

    public UserEntityFactory(LoginTypeDao inLoginTypeDao, AuthenticationMethodDao inAuthenticationMethodDao) {
        if (inLoginTypeDao == null) {
            throw new IllegalArgumentException("inLoginTypeDao cannot be null");
        }
        if (inAuthenticationMethodDao == null) {
            throw new IllegalArgumentException("inAuthenticationMethodDao cannot be null");
        }
        this.loginTypeDao = inLoginTypeDao;
        this.authenticationMethodDao = inAuthenticationMethodDao;
    }

    public LocalUserEntity getLocalUserEntityInstance() {
        LoginTypeEntity loginType = this.loginTypeDao.getByName(LoginType.INTERNAL);
        AuthenticationMethodEntity authenticationMethod = this.authenticationMethodDao.getByName(AuthenticationMethod.LOCAL);
        return new LocalUserEntity(loginType, authenticationMethod);
    }

    public LdapUserEntity getLdapUserEntityInstance() {
        LoginTypeEntity loginType = this.loginTypeDao.getByName(LoginType.INTERNAL);
        AuthenticationMethodEntity authenticationMethod = this.authenticationMethodDao.getByName(AuthenticationMethod.LDAP);
        return new LdapUserEntity(loginType, authenticationMethod);
    }

    public OAuthUserEntity getOAuthUserEntityInstance() {
        LoginTypeEntity loginType = this.loginTypeDao.getByName(LoginType.PROVIDER);
        AuthenticationMethodEntity authenticationMethod = this.authenticationMethodDao.getByName(AuthenticationMethod.OAUTH);
        return new OAuthUserEntity(loginType, authenticationMethod);
    }
}

