/*
 * Decompiled with CFR 0.152.
 */
package org.eurekaclinical.user.service.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eurekaclinical.user.client.comm.LdapUser;
import org.eurekaclinical.user.client.comm.LocalUser;
import org.eurekaclinical.user.client.comm.OAuthUser;
import org.eurekaclinical.user.client.comm.User;
import org.eurekaclinical.user.service.entity.LdapUserEntity;
import org.eurekaclinical.user.service.entity.LocalUserEntity;
import org.eurekaclinical.user.service.entity.OAuthUserEntity;
import org.eurekaclinical.user.service.entity.RoleEntity;
import org.eurekaclinical.user.service.entity.UserEntity;
import org.eurekaclinical.user.service.entity.UserEntityVisitor;

public class UserEntityToUserVisitor
implements UserEntityVisitor {
    private final List<User> results = new ArrayList();

    public void visit(Collection<? extends UserEntity> userEntities) {
        for (UserEntity userEntity : userEntities) {
            userEntity.accept((UserEntityVisitor)this);
        }
    }

    public void visit(LocalUserEntity localUserEntity) {
        LocalUser localUser = new LocalUser();
        this.toUser((User)localUser, (UserEntity)localUserEntity);
        localUser.setPassword(localUserEntity.getPassword());
        localUser.setPasswordExpiration(localUserEntity.getPasswordExpiration());
        localUser.setVerificationCode(localUserEntity.getVerificationCode());
        localUser.setVerified(localUserEntity.isVerified());
        this.results.add(localUser);
    }

    public void visit(LdapUserEntity ldapUserEntity) {
        LdapUser ldapUser = new LdapUser();
        this.toUser((User)ldapUser, (UserEntity)ldapUserEntity);
        this.results.add(ldapUser);
    }

    public void visit(OAuthUserEntity oauthUserEntity) {
        OAuthUser oauthUser = new OAuthUser();
        this.toUser((User)oauthUser, (UserEntity)oauthUserEntity);
        oauthUser.setProviderUsername(oauthUserEntity.getProviderUsername());
        oauthUser.setOAuthProvider(oauthUserEntity.getOAuthProvider().getId());
        this.results.add(oauthUser);
    }

    public List<User> getUsers() {
        return new ArrayList<User>(this.results);
    }

    public User getUser() {
        return this.results.isEmpty() ? null : (User)this.results.get(0);
    }

    private void toUser(User user, UserEntity inUserEntity) {
        if (inUserEntity != null) {
            user.setId(inUserEntity.getId());
            user.setActive(inUserEntity.isActive());
            user.setUsername(inUserEntity.getUsername());
            user.setEmail(inUserEntity.getEmail());
            user.setFirstName(inUserEntity.getFirstName());
            user.setLastName(inUserEntity.getLastName());
            user.setFullName(inUserEntity.getFullName());
            user.setLastLogin(inUserEntity.getLastLogin());
            user.setOrganization(inUserEntity.getOrganization());
            user.setRoles(this.rolesToRoleIds(inUserEntity.getRoles()));
            user.setDepartment(inUserEntity.getDepartment());
            user.setTitle(inUserEntity.getTitle());
        }
    }

    private List<Long> rolesToRoleIds(List<RoleEntity> inRoles) {
        ArrayList<Long> roleIds = new ArrayList<Long>(inRoles.size());
        for (RoleEntity role : inRoles) {
            roleIds.add(role.getId());
        }
        return roleIds;
    }
}

